/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.examples.remote;

import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Random;
import java.util.UUID;
import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.commands.SeekElapsedTimeCmd;
import org.mbari.vcr4j.examples.remote.AppArgs;
import org.mbari.vcr4j.remote.control.RVideoIO;
import org.mbari.vcr4j.remote.control.RemoteControl;
import org.mbari.vcr4j.remote.control.commands.FrameCaptureCmd;
import org.mbari.vcr4j.remote.control.commands.OpenCmd;
import org.mbari.vcr4j.remote.control.commands.RemoteCommands;
import org.mbari.vcr4j.remote.control.commands.VideoInfo;

public class Issue21 {
    public static void main(String[] args) throws Exception {
        AppArgs appArgs = AppArgs.parse(args, Issue21.class.getName());
        RemoteControl rc = appArgs.remoteControl();
        UUID uuid = appArgs.getVideoUuid();
        URL url = appArgs.url();
        RVideoIO io = rc.getVideoIO();
        Path pwd = Paths.get(".", new String[0]).normalize().toAbsolutePath();
        io.getVideoInfoObservable().subscribe(xs -> {
            if (xs.size() == 1) {
                VideoInfo head = (VideoInfo)xs.get(0);
                int et = new Random().nextInt(head.getDurationMillis().intValue());
                SeekElapsedTimeCmd cmd = new SeekElapsedTimeCmd(Duration.ofMillis(et));
                io.send((VideoCommand)cmd);
                Path targetSpace = pwd.resolve("trashme " + et + ".png");
                io.send((VideoCommand)new FrameCaptureCmd(uuid, UUID.randomUUID(), targetSpace.toString()));
                Thread.sleep(2000L);
            }
        });
        io.send((VideoCommand)new OpenCmd(uuid, url));
        Thread.sleep(2000L);
        io.send((VideoCommand)RemoteCommands.REQUEST_VIDEO_INFO);
    }
}

