/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.examples.sharktopoda;

import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.docopt.Docopt;
import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.commands.SeekElapsedTimeCmd;
import org.mbari.vcr4j.commands.ShuttleCmd;
import org.mbari.vcr4j.commands.VideoCommands;
import org.mbari.vcr4j.sharktopoda.SharktopodaVideoIO;
import org.mbari.vcr4j.sharktopoda.commands.OpenCmd;
import org.mbari.vcr4j.sharktopoda.commands.SharkCommands;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VideoInfoTest {
    public static void main(String[] args) throws Exception {
        Logger log = LoggerFactory.getLogger(VideoInfoTest.class);
        String prog = VideoInfoTest.class.getName();
        String doc = "Usage: " + prog + " <port> <url>...\nOptions:\n  -h, --help";
        Map opts = new Docopt(doc).parse(args);
        Integer port = Integer.parseInt((String)opts.get("<port>"));
        List urls = ((List)opts.get("<url>")).stream().map(s -> {
            Optional<Object> url;
            try {
                url = Optional.of(new URL((String)s));
            }
            catch (MalformedURLException e) {
                url = Optional.empty();
            }
            return url;
        }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        for (URL url : urls) {
            log.info("Opening " + url);
            Thread t = new Thread(() -> {
                try {
                    SharktopodaVideoIO io = new SharktopodaVideoIO(UUID.randomUUID(), "localhost", port.intValue());
                    io.getVideoInfoSubject().forEach(vi -> System.out.println(vi));
                    io.send((VideoCommand)new OpenCmd(url));
                    io.send((VideoCommand)SharkCommands.REQUEST_VIDEO_INFO);
                    io.send((VideoCommand)VideoCommands.PLAY);
                    Thread.sleep(3000L);
                    io.send((VideoCommand)new SeekElapsedTimeCmd(Duration.ofMillis(0L)));
                    io.send((VideoCommand)SharkCommands.SHOW);
                    Thread.sleep(3000L);
                    io.send((VideoCommand)SharkCommands.SHOW);
                    Thread.sleep(3000L);
                    io.send((VideoCommand)new ShuttleCmd(-0.1));
                    io.send((VideoCommand)SharkCommands.SHOW);
                    Thread.sleep(4000L);
                    io.send((VideoCommand)SharkCommands.CLOSE);
                }
                catch (Exception e) {
                    log.error("Thread died", (Throwable)e);
                }
            });
            t.setDaemon(false);
            t.start();
            Thread.sleep(1000L);
        }
    }
}

