/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.examples.jserialcomm;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.docopt.Docopt;
import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.VideoIO;
import org.mbari.vcr4j.commands.VideoCommands;
import org.mbari.vcr4j.decorators.VCRSyncDecorator;
import org.mbari.vcr4j.decorators.VideoIndexAsString;
import org.mbari.vcr4j.jserialcomm.SerialCommVideoIO;
import org.mbari.vcr4j.rs422.RS422State;
import org.mbari.vcr4j.rs422.VCRVideoIO;
import org.mbari.vcr4j.rs422.decorators.RS422StatusDecorator;
import org.mbari.vcr4j.rs422.decorators.UserbitsAsTimeDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VARSDemo01 {
    public static void main(String[] args) throws Exception {
        String prog = VARSDemo01.class.getName();
        String doc = "Usage: " + prog + " <commport> [options]\n\n" + "Options:\n" + "  -h, --help";
        Map opts = new Docopt(doc).parse(args);
        String portName = (String)opts.get("<commport>");
        Logger log = LoggerFactory.getLogger(VARSDemo01.class);
        SerialCommVideoIO io = SerialCommVideoIO.open((String)portName);
        VCRSyncDecorator syncDecorator = new VCRSyncDecorator((VideoIO)io);
        RS422StatusDecorator statusDecorator = new RS422StatusDecorator((VCRVideoIO)io);
        UserbitsAsTimeDecorator timeDecorator = new UserbitsAsTimeDecorator((VCRVideoIO)io);
        timeDecorator.getIndexObservable().subscribe(vi -> log.debug("USERBITS: " + new VideoIndexAsString(vi).toString()));
        io.send((VideoCommand)VideoCommands.PLAY);
        AtomicBoolean wait = new AtomicBoolean(true);
        io.getStateObservable().filter(RS422State::isPlaying).take(1L).forEach(state -> {
            log.info("THE DEVICE IS PLAYING");
            wait.set(false);
        });
        while (wait.get()) {
            Thread.sleep(200L);
        }
        log.info("DEVICE IS IN PLAY MODE. REQUESTING TIME AT 1 SEC INTERVALS");
        int i = 0;
        while (i < 5) {
            io.send((VideoCommand)VideoCommands.REQUEST_TIMESTAMP);
            Thread.sleep(1000L);
            ++i;
        }
        io.getStateObservable().filter(RS422State::isStopped).take(1L).forEach(state -> io.close());
        log.info("STOPPING DEVICE");
        io.send((VideoCommand)VideoCommands.STOP);
    }
}

