/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.examples.purejavacomm;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.docopt.Docopt;
import org.mbari.vcr4j.VideoController;
import org.mbari.vcr4j.VideoIO;
import org.mbari.vcr4j.decorators.VCRSyncDecorator;
import org.mbari.vcr4j.purejavacomm.PJCVideoIO;
import org.mbari.vcr4j.rs422.VCRVideoIO;
import org.mbari.vcr4j.rs422.decorators.RS422LoggingDecorator;

public class SimpleDemo02 {
    public static void main(String[] args) throws Exception {
        String prog = SimpleDemo02.class.getName();
        String doc = "Usage: " + prog + " <commport> [options]\n\n" + "Options:\n" + "  -h, --help";
        Map opts = new Docopt(doc).parse(args);
        String portName = (String)opts.get("<commport>");
        PJCVideoIO io = PJCVideoIO.open((String)portName);
        RS422LoggingDecorator loggingDecorator = new RS422LoggingDecorator((VCRVideoIO)io);
        VCRSyncDecorator syncDecorator = new VCRSyncDecorator((VideoIO)io);
        VideoController controller = new VideoController((VideoIO)io);
        controller.play();
        controller.requestStatus();
        AtomicBoolean wait = new AtomicBoolean(true);
        io.getStateObservable().filter(state -> state.isPlaying() && !state.isStandingBy()).take(1L).forEach(state -> wait.set(false));
        while (wait.get()) {
            Thread.sleep(200L);
        }
        controller.requestTimecode();
        Thread.sleep(4000L);
        controller.stop();
        Thread.sleep(1000L);
        io.close();
        System.exit(0);
    }
}

