/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.examples.remote;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.docopt.Docopt;
import org.mbari.vcr4j.remote.control.RemoteControl;
import org.mbari.vcr4j.remote.control.commands.localization.Localization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record AppArgs(RemoteControl remoteControl, URL url) {
    private static final Logger log = LoggerFactory.getLogger(AppArgs.class);

    public UUID getVideoUuid() {
        return this.remoteControl.getVideoIO().getUuid();
    }

    public static AppArgs parse(String[] args, String className) throws Exception {
        String doc = "Usage: %s <port> <url>\nOptions:\n  -h, --help\n".formatted(className);
        Map opts = new Docopt(doc).parse(args);
        int port = Integer.parseInt((String)opts.get("<port>"));
        URL url = new URL((String)opts.get("<url>"));
        UUID uuid = UUID.randomUUID();
        RemoteControl io = (RemoteControl)new RemoteControl.Builder(uuid).port(5555).remotePort(port).remoteHost("localhost").build().get();
        io.getVideoIO().getErrorObservable().subscribe(e -> log.atWarn().log("ERROR: " + e));
        return new AppArgs(io, url);
    }

    public static List<Localization> buildLocalizations(int n, long durationMillis, int width, int height) {
        Random random = new Random();
        ArrayList<Localization> locs = new ArrayList<Localization>();
        int i = 0;
        while (i < n) {
            String color = String.format("#%06x", random.nextInt(0x1000000));
            Localization loc = new Localization(UUID.randomUUID(), "foo-" + i, Long.valueOf(random.nextLong(0L, durationMillis)), Long.valueOf(random.nextLong(0L, 30000L)), Integer.valueOf(random.nextInt(0, width - 100)), Integer.valueOf(random.nextInt(0, height - 100)), Integer.valueOf(random.nextInt(0, 100)), Integer.valueOf(random.nextInt(0, 100)), color);
            locs.add(loc);
            ++i;
        }
        return locs;
    }
}

