/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.examples.remote;

import java.net.URL;
import java.time.Duration;
import java.util.List;
import java.util.UUID;
import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.commands.SeekElapsedTimeCmd;
import org.mbari.vcr4j.examples.remote.AppArgs;
import org.mbari.vcr4j.remote.control.RVideoIO;
import org.mbari.vcr4j.remote.control.RemoteControl;
import org.mbari.vcr4j.remote.control.commands.OpenCmd;
import org.mbari.vcr4j.remote.control.commands.localization.AddLocalizationsCmd;
import org.mbari.vcr4j.remote.control.commands.localization.Localization;
import org.mbari.vcr4j.remote.control.commands.localization.SelectLocalizationsCmd;
import org.mbari.vcr4j.remote.control.commands.localization.UpdateLocalizationsCmd;

public class Issue19 {
    public static void main(String[] args) throws Exception {
        AppArgs appArgs = AppArgs.parse(args, Issue19.class.getName());
        RemoteControl rc = appArgs.remoteControl();
        UUID uuid = appArgs.getVideoUuid();
        URL url = appArgs.url();
        RVideoIO io = rc.getVideoIO();
        io.send((VideoCommand)new OpenCmd(uuid, url));
        long elapsedTimeMillis = 10000L;
        Duration elapsedTime = Duration.ofMillis(elapsedTimeMillis);
        Localization loc = new Localization(UUID.randomUUID(), "Brian was here", Long.valueOf(elapsedTimeMillis), Long.valueOf(0L), Integer.valueOf(100), Integer.valueOf(200), Integer.valueOf(300), Integer.valueOf(400), "#FF3434");
        List<Localization> locs = List.of(loc);
        List<SelectLocalizationsCmd> cmds = List.of(new AddLocalizationsCmd(uuid, locs), new SeekElapsedTimeCmd(elapsedTime), new SelectLocalizationsCmd(uuid, locs.stream().map(Localization::getUuid).toList()));
        Thread.sleep(2000L);
        cmds.forEach(arg_0 -> ((RVideoIO)io).send(arg_0));
        Thread.sleep(5000L);
        Localization updatedLoc = new Localization(loc.getUuid(), "Brian is now over here", Long.valueOf(elapsedTimeMillis), Long.valueOf(0L), Integer.valueOf(500), Integer.valueOf(500), Integer.valueOf(300), Integer.valueOf(400), "#FF3434");
        io.send((VideoCommand)new UpdateLocalizationsCmd(uuid, List.of(updatedLoc)));
        Thread.sleep(2000L);
    }
}

