/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.examples.remote;

import io.reactivex.rxjava3.schedulers.Schedulers;
import java.net.URL;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.UUID;
import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.examples.remote.AppArgs;
import org.mbari.vcr4j.remote.control.RVideoIO;
import org.mbari.vcr4j.remote.control.RemoteControl;
import org.mbari.vcr4j.remote.control.commands.OpenCmd;
import org.mbari.vcr4j.remote.control.commands.localization.AddLocalizationsCmd;
import org.mbari.vcr4j.remote.control.commands.localization.Localization;
import org.mbari.vcr4j.remote.control.commands.localization.SelectLocalizationsCmd;
import org.mbari.vcr4j.remote.control.commands.localization.UpdateLocalizationsCmd;
import org.mbari.vcr4j.remote.player.RxControlRequestHandler;

public class Issue28a {
    public static void main(String[] args) throws Exception {
        AppArgs appArgs = AppArgs.parse(args, Issue28a.class.getName());
        RemoteControl rc = appArgs.remoteControl();
        UUID uuid = appArgs.getVideoUuid();
        URL url = appArgs.url();
        RVideoIO io = rc.getVideoIO();
        RxControlRequestHandler rh = rc.getRequestHandler();
        DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmssXXX");
        rh.getLocalizationsCmdObservable().ofType(AddLocalizationsCmd.class).observeOn(Schedulers.io()).subscribe(cmd -> {
            List locs = ((AddLocalizationsCmd.Request)cmd.getValue()).getLocalizations();
            Thread.sleep(1000L);
            String concept = dateFormat.format(ZonedDateTime.now(ZoneId.of("UTC")));
            locs.forEach(x -> x.setConcept(concept));
            io.send((VideoCommand)new UpdateLocalizationsCmd(uuid, locs));
            io.send((VideoCommand)new SelectLocalizationsCmd(uuid, locs.stream().map(Localization::getUuid).toList()));
        });
        io.send((VideoCommand)new OpenCmd(uuid, url));
        Thread.sleep(120000L);
    }
}

