/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.examples.remote;

import java.net.URL;
import java.time.Duration;
import java.util.List;
import java.util.UUID;
import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.commands.SeekElapsedTimeCmd;
import org.mbari.vcr4j.remote.control.RVideoIO;
import org.mbari.vcr4j.remote.control.RemoteControl;
import org.mbari.vcr4j.remote.control.commands.OpenCmd;
import org.mbari.vcr4j.remote.control.commands.localization.AddLocalizationsCmd;
import org.mbari.vcr4j.remote.control.commands.localization.Localization;
import org.mbari.vcr4j.remote.control.commands.localization.SelectLocalizationsCmd;
import org.mbari.vcr4j.remote.control.commands.localization.UpdateLocalizationsCmd;

public class Issue28b {
    public static void main(String[] args) throws Exception {
        URL url = new URL("http://varsdemo.mbari.org/media/M3/proxy/Ventana/2017/03/4003/V4003_20170301T210458.233Z_t4s4_1280_tc03560915_h264.mp4");
        UUID uuid = UUID.fromString("5dc0e157-5802-4844-8a7f-71d449a9275e");
        RemoteControl remoteControl = (RemoteControl)new RemoteControl.Builder(uuid).port(5555).remotePort(8800).remoteHost("localhost").build().get();
        RVideoIO io = remoteControl.getVideoIO();
        io.send((VideoCommand)new OpenCmd(uuid, url));
        Thread.sleep(3000L);
        Localization localization = new Localization(UUID.fromString("e574ba65-44c2-4758-b558-35bbf9a531ba"), "initial concept", Long.valueOf(60000L), Long.valueOf(0L), Integer.valueOf(100), Integer.valueOf(200), Integer.valueOf(148), Integer.valueOf(144), "#00FFFF");
        List<Localization> xs = List.of(localization);
        io.send((VideoCommand)new SeekElapsedTimeCmd(Duration.ofMillis(60000L)));
        io.send((VideoCommand)new AddLocalizationsCmd(uuid, xs));
        io.send((VideoCommand)new SelectLocalizationsCmd(uuid, xs.stream().map(Localization::getUuid).toList()));
        Thread.sleep(1000L);
        localization.setConcept("20221220T220139Z");
        io.send((VideoCommand)new UpdateLocalizationsCmd(uuid, xs));
        io.send((VideoCommand)new SelectLocalizationsCmd(uuid, xs.stream().map(Localization::getUuid).toList()));
        Thread.sleep(200L);
        io.close();
    }
}

