/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.examples.remote;

import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.docopt.Docopt;
import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.commands.RemoteCommands;
import org.mbari.vcr4j.remote.control.RVideoIO;
import org.mbari.vcr4j.remote.control.RemoteControl;
import org.mbari.vcr4j.remote.control.commands.OpenCmd;
import org.mbari.vcr4j.remote.control.commands.localization.AddLocalizationsCmd;
import org.mbari.vcr4j.remote.player.RxControlRequestHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Issue36 {
    private static final Logger log = LoggerFactory.getLogger(Issue36.class);
    private static final ExecutorService executor = Executors.newSingleThreadExecutor();

    private static Optional<URL> toUrl(String s) {
        String corrected = s.startsWith("http") || s.startsWith("file:") ? s : "file:" + s;
        try {
            return Optional.of(new URL(corrected));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private static Args parse(String[] args) throws Exception {
        String doc = "Usage: %s <port> <url>...\nOptions:\n  -h, --help\n".formatted(Issue36.class.getName());
        Map opts = new Docopt(doc).parse(args);
        int port = Integer.parseInt((String)opts.get("<port>"));
        List<URL> urls = ((List)opts.get("<url>")).stream().flatMap(s -> Issue36.toUrl(s).stream()).toList();
        return new Args(port, urls);
    }

    public static void run(int port, List<URL> urls) {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e2) {
            throw new RuntimeException(e2);
        }
        if (urls == null || urls.isEmpty()) {
            return;
        }
        UUID uuid = UUID.randomUUID();
        RemoteControl rc = (RemoteControl)new RemoteControl.Builder(uuid).port(5555).remotePort(port).remoteHost("localhost").build().get();
        RVideoIO io = rc.getVideoIO();
        RxControlRequestHandler rh = rc.getRequestHandler();
        io.getErrorObservable().subscribe(e -> log.atWarn().log("ERROR: " + e));
        Scheduler scheduler = Schedulers.single();
        AtomicInteger count = new AtomicInteger(3);
        rh.getLocalizationsCmdObservable().ofType(AddLocalizationsCmd.class).observeOn(scheduler).subscribe(cmd -> {
            log.atInfo().log("Adding " + ((AddLocalizationsCmd.Request)cmd.getValue()).getLocalizations().size() + " localizations");
            int remaining = count.decrementAndGet();
            if (remaining == 0) {
                executor.submit(() -> io.send((VideoCommand)RemoteCommands.CLOSE));
                executor.submit(() -> ((RemoteControl)rc).close());
                if (urls.size() > 1) {
                    executor.submit(() -> Issue36.run(port, urls.subList(1, urls.size())));
                }
            }
        });
        URL url = urls.get(0);
        log.atInfo().log("Opening " + url);
        io.send((VideoCommand)new OpenCmd(uuid, url));
    }

    public static void main(String[] args) throws Exception {
        Args xs = Issue36.parse(args);
        executor.submit(() -> Issue36.run(xs.port(), xs.urls()));
        Thread.sleep(120000L);
    }

    private record Args(int port, List<URL> urls) {
    }
}

