/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.examples.remote;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.docopt.Docopt;
import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.commands.VideoCommands;
import org.mbari.vcr4j.examples.sharktopoda.MultiOpenDemo01;
import org.mbari.vcr4j.examples.sharktopoda.VideoInfoTest;
import org.mbari.vcr4j.remote.control.RVideoIO;
import org.mbari.vcr4j.remote.control.commands.CloseCmd;
import org.mbari.vcr4j.remote.control.commands.OpenCmd;
import org.mbari.vcr4j.remote.control.commands.PlayCmd;
import org.mbari.vcr4j.remote.control.commands.RequestVideoInfoCmd;
import org.mbari.vcr4j.remote.control.commands.ShowCmd;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiOpenDemo1 {
    public static void main(String[] args) {
        Logger log = LoggerFactory.getLogger(VideoInfoTest.class);
        String prog = MultiOpenDemo01.class.getName();
        String doc = "Usage: " + prog + " <port> <url>...\n" + "Options:\n" + "  -h, --help";
        Map opts = new Docopt(doc).parse(args);
        int port = Integer.parseInt((String)opts.get("<port>"));
        List<URL> urls = ((List)opts.get("<url>")).stream().map(s -> {
            Optional<Object> url;
            try {
                url = Optional.of(new URL((String)s));
            }
            catch (MalformedURLException e) {
                url = Optional.empty();
            }
            return url;
        }).filter(Optional::isPresent).map(Optional::get).toList();
        long interval = (long)urls.size() * 1000L;
        for (URL url : urls) {
            log.info("Opening " + url);
            Thread t = new Thread(() -> {
                try {
                    UUID uuid = UUID.randomUUID();
                    RVideoIO io = new RVideoIO(uuid, "localhost", port);
                    io.getVideoInfoObservable().forEach(System.out::println);
                    io.send((VideoCommand)new OpenCmd(uuid, url));
                    io.send((VideoCommand)new RequestVideoInfoCmd());
                    Thread.sleep(interval + 2000L);
                    io.send((VideoCommand)VideoCommands.PLAY);
                    Thread.sleep(interval);
                    int i = 1;
                    while (i < 6) {
                        double rate = 1.0 - 1.0 / Integer.valueOf(i).doubleValue();
                        System.out.println("----" + rate);
                        io.send((VideoCommand)new ShowCmd(uuid));
                        io.send((VideoCommand)new PlayCmd(uuid, Double.valueOf(rate)));
                        Thread.sleep(interval);
                        ++i;
                    }
                    Thread.sleep(interval);
                    io.send((VideoCommand)VideoCommands.STOP);
                    Thread.sleep(interval);
                    io.send((VideoCommand)new CloseCmd(uuid));
                    io.close();
                }
                catch (Exception e) {
                    log.error("Thread died", (Throwable)e);
                }
            });
            t.setDaemon(false);
            t.start();
        }
    }
}

