/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.examples.sharktopoda;

import java.io.File;
import java.net.URL;
import java.time.Duration;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.docopt.Docopt;
import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.commands.RemoteCommands;
import org.mbari.vcr4j.commands.SeekElapsedTimeCmd;
import org.mbari.vcr4j.commands.VideoCommands;
import org.mbari.vcr4j.examples.sharktopoda.SeekElapsedTimeTest;
import org.mbari.vcr4j.sharktopoda.SharktopodaState;
import org.mbari.vcr4j.sharktopoda.SharktopodaVideoIO;
import org.mbari.vcr4j.sharktopoda.commands.FramecaptureCmd;
import org.mbari.vcr4j.sharktopoda.commands.OpenCmd;
import org.mbari.vcr4j.sharktopoda.decorators.FramecaptureDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FramecaptureTest {
    private static final int localPort = 6789;

    public static void main(String[] args) throws Exception {
        String prog = FramecaptureTest.class.getName();
        String doc = "Usage: " + prog + " <port> <url> <dir>\n" + "Options:\n" + "  -h, --help";
        Map opts = new Docopt(doc).parse(args);
        Integer port = Integer.parseInt((String)opts.get("<port>"));
        URL url = new URL((String)opts.get("<url>"));
        File file = new File((String)opts.get("<dir>"));
        file.mkdirs();
        Logger log = LoggerFactory.getLogger(SeekElapsedTimeTest.class);
        SharktopodaVideoIO io = new SharktopodaVideoIO(UUID.randomUUID(), "localhost", port.intValue());
        FramecaptureDecorator decorator = new FramecaptureDecorator(io, 6789);
        decorator.getFramecaptureObservable().forEach(r -> System.out.println(r.getImageLocation()));
        AtomicBoolean wait = new AtomicBoolean(true);
        io.getStateObservable().filter(SharktopodaState::isConnected).take(1L).forEach(state -> {
            log.info("The video is ready.");
            wait.set(false);
        });
        io.send((VideoCommand)new OpenCmd(url));
        while (wait.get()) {
            Thread.sleep(1000L);
        }
        io.send((VideoCommand)new FramecaptureCmd(UUID.randomUUID(), new File(file, "trashme-0.png")));
        int i = 0;
        while (i < 5) {
            io.send((VideoCommand)new SeekElapsedTimeCmd(Duration.ofSeconds(i * 3)));
            Thread.sleep(1000L);
            io.send((VideoCommand)new FramecaptureCmd(UUID.randomUUID(), new File(file, "trashme-seek-" + i + ".png")));
            ++i;
        }
        io.send((VideoCommand)VideoCommands.PLAY);
        i = 0;
        while (i < 5) {
            Thread.sleep(1000L);
            io.send((VideoCommand)new FramecaptureCmd(UUID.randomUUID(), new File(file, "trashme-play-" + i + ".png")));
            ++i;
        }
        io.send((VideoCommand)RemoteCommands.CLOSE);
    }
}

