/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.examples.sharktopoda;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.docopt.Docopt;
import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.commands.RemoteCommands;
import org.mbari.vcr4j.commands.ShuttleCmd;
import org.mbari.vcr4j.commands.VideoCommands;
import org.mbari.vcr4j.examples.sharktopoda.VideoInfoTest;
import org.mbari.vcr4j.sharktopoda.SharktopodaVideoIO;
import org.mbari.vcr4j.sharktopoda.commands.OpenCmd;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiOpenDemo01 {
    public static void main(String[] args) throws Exception {
        Logger log = LoggerFactory.getLogger(VideoInfoTest.class);
        String prog = MultiOpenDemo01.class.getName();
        String doc = "Usage: " + prog + " <port> <url>...\n" + "Options:\n" + "  -h, --help";
        Map opts = new Docopt(doc).parse(args);
        Integer port = Integer.parseInt((String)opts.get("<port>"));
        List urls = ((List)opts.get("<url>")).stream().map(s -> {
            Optional<Object> url;
            try {
                url = Optional.of(new URL((String)s));
            }
            catch (MalformedURLException e) {
                url = Optional.empty();
            }
            return url;
        }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        long interval = urls.size() * 1000;
        for (URL url : urls) {
            log.info("Opening " + url);
            Thread t = new Thread(() -> {
                try {
                    SharktopodaVideoIO io = new SharktopodaVideoIO(UUID.randomUUID(), "localhost", port.intValue());
                    io.getVideoInfoSubject().forEach(vi -> System.out.println(vi));
                    io.send((VideoCommand)new OpenCmd(url));
                    io.send((VideoCommand)RemoteCommands.REQUEST_VIDEO_INFO);
                    Thread.sleep(interval + 2000L);
                    io.send((VideoCommand)VideoCommands.PLAY);
                    Thread.sleep(interval);
                    int i = 1;
                    while (i < 6) {
                        double rate = 1.0 - 1.0 / Integer.valueOf(i).doubleValue();
                        System.out.println("----" + rate);
                        io.send((VideoCommand)RemoteCommands.SHOW);
                        io.send((VideoCommand)new ShuttleCmd(rate));
                        Thread.sleep(interval);
                        ++i;
                    }
                    Thread.sleep(interval);
                    io.send((VideoCommand)VideoCommands.STOP);
                    Thread.sleep(interval);
                    io.send((VideoCommand)RemoteCommands.CLOSE);
                }
                catch (Exception e) {
                    log.error("Thread died", (Throwable)e);
                }
            });
            t.setDaemon(false);
            t.start();
        }
    }
}

