/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.examples.sharktopoda;

import java.net.URL;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.docopt.Docopt;
import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.VideoIO;
import org.mbari.vcr4j.commands.RemoteCommands;
import org.mbari.vcr4j.commands.SeekElapsedTimeCmd;
import org.mbari.vcr4j.commands.ShuttleCmd;
import org.mbari.vcr4j.commands.VideoCommands;
import org.mbari.vcr4j.sharktopoda.SharktopodaError;
import org.mbari.vcr4j.sharktopoda.SharktopodaState;
import org.mbari.vcr4j.sharktopoda.SharktopodaVideoIO;
import org.mbari.vcr4j.sharktopoda.commands.OpenCmd;

public class SingleVideoDemo01 {
    private static VideoIO<SharktopodaState, SharktopodaError> io;

    public static void main(String[] args) throws Exception {
        String prog = SingleVideoDemo01.class.getName();
        String doc = "Usage: " + prog + " <port> <url>\n" + "Options:\n" + "  -h, --help";
        Map opts = new Docopt(doc).parse(args);
        Integer port = Integer.parseInt((String)opts.get("<port>"));
        URL url = new URL((String)opts.get("<url>"));
        io = new SharktopodaVideoIO(UUID.randomUUID(), "localhost", port.intValue());
        List<VideoCommand> cmds = Arrays.asList(new OpenCmd(url), VideoCommands.PLAY, RemoteCommands.SHOW, RemoteCommands.REQUEST_VIDEO_INFO, RemoteCommands.REQUEST_ALL_VIDEO_INFOS, VideoCommands.REQUEST_ELAPSED_TIME, VideoCommands.REQUEST_INDEX, VideoCommands.REQUEST_STATUS, new SeekElapsedTimeCmd(Duration.ofMillis(3000L)), new ShuttleCmd(0.5), new ShuttleCmd(-0.5), new ShuttleCmd(0.1), new ShuttleCmd(-0.1), VideoCommands.PAUSE, RemoteCommands.CLOSE, VideoCommands.REQUEST_INDEX);
        for (VideoCommand cmd : cmds) {
            SingleVideoDemo01.doCommand(cmd);
        }
    }

    private static void doCommand(VideoCommand cmd) throws Exception {
        io.send(cmd);
        Thread.sleep(500L);
    }
}

