/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.examples.sharktopoda;

import java.net.URL;
import java.util.Map;
import java.util.UUID;
import org.docopt.Docopt;
import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.VideoIO;
import org.mbari.vcr4j.VideoState;
import org.mbari.vcr4j.commands.RemoteCommands;
import org.mbari.vcr4j.commands.VideoCommands;
import org.mbari.vcr4j.decorators.LoggingDecorator;
import org.mbari.vcr4j.decorators.VideoSyncDecorator;
import org.mbari.vcr4j.sharktopoda.SharktopodaError;
import org.mbari.vcr4j.sharktopoda.SharktopodaState;
import org.mbari.vcr4j.sharktopoda.SharktopodaVideoIO;
import org.mbari.vcr4j.sharktopoda.commands.OpenCmd;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VARSDemo01 {
    private static VideoIO<SharktopodaState, SharktopodaError> io;

    public static void main(String[] args) throws Exception {
        String prog = VARSDemo01.class.getName();
        String doc = "Usage: " + prog + " <port> <url>\n" + "Options:\n" + "  -h, --help";
        Map opts = new Docopt(doc).parse(args);
        Integer port = Integer.parseInt((String)opts.get("<port>"));
        URL url = new URL((String)opts.get("<url>"));
        Logger log = LoggerFactory.getLogger(VARSDemo01.class);
        io = new SharktopodaVideoIO(UUID.randomUUID(), "localhost", port.intValue());
        VideoSyncDecorator syncDecorator = new VideoSyncDecorator(io);
        new LoggingDecorator(io);
        io.send((VideoCommand)new OpenCmd(url));
        io.send((VideoCommand)VideoCommands.PLAY);
        Thread.sleep(2000L);
        log.info("STOPPING DEVICE");
        io.send((VideoCommand)VideoCommands.STOP);
        syncDecorator.unsubscribe();
        io.getCommandSubject().subscribe(vc -> {}, e -> {}, () -> System.exit(0));
        io.getStateObservable().filter(VideoState::isStopped).take(1L).forEach(state -> {
            io.send((VideoCommand)RemoteCommands.CLOSE);
            io.close();
        });
        io.send((VideoCommand)VideoCommands.REQUEST_STATUS);
    }
}

