/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.examples.sharktopoda;

import java.net.URL;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.docopt.Docopt;
import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.VideoIO;
import org.mbari.vcr4j.VideoState;
import org.mbari.vcr4j.commands.RemoteCommands;
import org.mbari.vcr4j.commands.VideoCommands;
import org.mbari.vcr4j.decorators.LoggingDecorator;
import org.mbari.vcr4j.decorators.SchedulerVideoIO;
import org.mbari.vcr4j.decorators.StatusDecorator;
import org.mbari.vcr4j.decorators.VCRSyncDecorator;
import org.mbari.vcr4j.sharktopoda.SharktopodaState;
import org.mbari.vcr4j.sharktopoda.SharktopodaVideoIO;
import org.mbari.vcr4j.sharktopoda.commands.OpenCmd;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VARSDemo02 {
    public static void main(String[] args) throws Exception {
        String prog = VARSDemo02.class.getName();
        String doc = "Usage: " + prog + " <port> <url>\n" + "Options:\n" + "  -h, --help";
        Map opts = new Docopt(doc).parse(args);
        Integer port = Integer.parseInt((String)opts.get("<port>"));
        URL url = new URL((String)opts.get("<url>"));
        Logger log = LoggerFactory.getLogger(VARSDemo02.class);
        SharktopodaVideoIO videoIO = new SharktopodaVideoIO(UUID.randomUUID(), "localhost", port.intValue());
        new StatusDecorator((VideoIO)videoIO);
        new VCRSyncDecorator((VideoIO)videoIO, 1000L, 100L, 3000000L);
        new LoggingDecorator((VideoIO)videoIO);
        SchedulerVideoIO io = new SchedulerVideoIO((VideoIO)videoIO, (Executor)Executors.newCachedThreadPool());
        io.send((VideoCommand)new OpenCmd(url));
        io.send((VideoCommand)RemoteCommands.SHOW);
        io.send((VideoCommand)VideoCommands.PLAY);
        Thread.sleep(2000L);
        log.info("DEVICE IS IN PLAY MODE. REQUESTING TIME AT 1 SEC INTERVALS");
        int i = 0;
        while (i < 5) {
            io.send((VideoCommand)VideoCommands.REQUEST_TIMESTAMP);
            Thread.sleep(1000L);
            ++i;
        }
        log.info("STOPPING DEVICE");
        io.send((VideoCommand)VideoCommands.STOP);
        io.getCommandSubject().subscribe(vc -> {}, e -> {}, () -> System.exit(0));
        io.getStateObservable().filter(VideoState::isStopped).take(1L).forEach(arg_0 -> VARSDemo02.lambda$4((VideoIO)io, arg_0));
        io.send((VideoCommand)VideoCommands.REQUEST_STATUS);
    }

    private static /* synthetic */ void lambda$4(VideoIO videoIO, SharktopodaState state) throws Throwable {
        videoIO.send((VideoCommand)RemoteCommands.CLOSE);
        videoIO.close();
    }
}

