/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.examples.remote;

import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.net.URL;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.commands.SeekElapsedTimeCmd;
import org.mbari.vcr4j.examples.remote.AppArgs;
import org.mbari.vcr4j.examples.remote.Issue28a;
import org.mbari.vcr4j.remote.control.RVideoIO;
import org.mbari.vcr4j.remote.control.RemoteControl;
import org.mbari.vcr4j.remote.control.commands.OpenCmd;
import org.mbari.vcr4j.remote.control.commands.localization.AddLocalizationsCmd;
import org.mbari.vcr4j.remote.control.commands.localization.Localization;
import org.mbari.vcr4j.remote.control.commands.localization.SelectLocalizationsCmd;
import org.mbari.vcr4j.remote.control.commands.localization.UpdateLocalizationsCmd;
import org.mbari.vcr4j.remote.player.RxControlRequestHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Issue31 {
    private static final Logger log = LoggerFactory.getLogger(Issue31.class);

    public static void main(String[] args) throws Exception {
        AppArgs appArgs = AppArgs.parse(args, Issue28a.class.getName());
        RemoteControl rc = appArgs.remoteControl();
        UUID uuid = appArgs.getVideoUuid();
        URL url = appArgs.url();
        RVideoIO io = rc.getVideoIO();
        RxControlRequestHandler rh = rc.getRequestHandler();
        DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmssXXX");
        long elapsedTimeMillis = 10000L;
        CopyOnWriteArrayList<Localization> locs = new CopyOnWriteArrayList<Localization>(AppArgs.buildLocalizations(10, 60000L, 1280, 720));
        locs.forEach(x -> x.setElapsedTimeMillis(Long.valueOf(elapsedTimeMillis)));
        Scheduler scheduler = Schedulers.single();
        rh.getLocalizationsCmdObservable().ofType(SelectLocalizationsCmd.class).observeOn(scheduler).subscribe(cmd -> {
            List uuids = ((SelectLocalizationsCmd.Request)cmd.getValue()).getLocalizations();
            String s = uuids.stream().map(Objects::toString).collect(Collectors.joining(", "));
            log.atInfo().log("Sharktopoda selected " + s);
            String concept = dateFormat.format(ZonedDateTime.now(ZoneId.of("UTC")));
            List updatedLocs = uuids.stream().flatMap(key -> locs.stream().filter(x -> x.getUuid().equals(key)).findFirst().stream().peek(x -> x.setConcept(concept))).toList();
            io.send((VideoCommand)new UpdateLocalizationsCmd(uuid, updatedLocs));
            io.send((VideoCommand)new SelectLocalizationsCmd(uuid, uuids));
        });
        rh.getLocalizationsCmdObservable().ofType(AddLocalizationsCmd.class).observeOn(scheduler).subscribe(cmd -> {
            log.atInfo().log("Adding " + ((AddLocalizationsCmd.Request)cmd.getValue()).getLocalizations().size());
            locs.addAll(((AddLocalizationsCmd.Request)cmd.getValue()).getLocalizations());
        });
        io.send((VideoCommand)new OpenCmd(uuid, url));
        Thread.sleep(2000L);
        io.send((VideoCommand)new AddLocalizationsCmd(uuid, locs));
        io.send((VideoCommand)new SelectLocalizationsCmd(uuid, locs.stream().map(Localization::getUuid).toList()));
        io.send((VideoCommand)new SeekElapsedTimeCmd(Duration.ofMillis(elapsedTimeMillis)));
        Thread.sleep(120000L);
    }
}

