/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.examples.remote;

import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Random;
import java.util.UUID;
import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.commands.RemoteCommands;
import org.mbari.vcr4j.commands.SeekElapsedTimeCmd;
import org.mbari.vcr4j.commands.VideoCommands;
import org.mbari.vcr4j.examples.remote.AppArgs;
import org.mbari.vcr4j.remote.control.RVideoIO;
import org.mbari.vcr4j.remote.control.RemoteControl;
import org.mbari.vcr4j.remote.control.commands.FrameCaptureCmd;
import org.mbari.vcr4j.remote.control.commands.OpenCmd;
import org.mbari.vcr4j.remote.control.commands.VideoInfo;

public class Issue33 {
    public static void main(String[] args) throws Exception {
        AppArgs appArgs = AppArgs.parse(args, Issue33.class.getName());
        RemoteControl rc = appArgs.remoteControl();
        UUID uuid = appArgs.getVideoUuid();
        URL url = appArgs.url();
        RVideoIO io = rc.getVideoIO();
        io.getVideoInfoObservable().subscribe(xs -> {
            if (xs.size() == 1) {
                VideoInfo head = (VideoInfo)xs.get(0);
                Issue33.doStuff(io, head);
            }
        });
        io.send((VideoCommand)new OpenCmd(uuid, url));
        Thread.sleep(2000L);
        io.send((VideoCommand)RemoteCommands.REQUEST_VIDEO_INFO);
    }

    private static void doStuff(RVideoIO io, VideoInfo videoInfo) throws Exception {
        io.send((VideoCommand)VideoCommands.PAUSE);
        Path pwd = Paths.get(".", new String[0]).normalize().toAbsolutePath();
        int et = new Random().nextInt(videoInfo.getDurationMillis().intValue());
        io.send((VideoCommand)new SeekElapsedTimeCmd(Duration.ofMillis(et)));
        io.send((VideoCommand)VideoCommands.PAUSE);
        io.send((VideoCommand)VideoCommands.REQUEST_INDEX);
        Path targetSpace = pwd.resolve("trashme " + et + ".png");
        io.send((VideoCommand)new FrameCaptureCmd(videoInfo.getUuid(), UUID.randomUUID(), targetSpace.toString()));
        Thread.sleep(2000L);
    }
}

