/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.examples.remote;

import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.docopt.Docopt;
import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.commands.VideoCommands;
import org.mbari.vcr4j.examples.remote.AppArgs;
import org.mbari.vcr4j.examples.remote.TestCommands01;
import org.mbari.vcr4j.remote.control.RError;
import org.mbari.vcr4j.remote.control.RemoteControl;
import org.mbari.vcr4j.remote.control.commands.OpenCmd;
import org.mbari.vcr4j.remote.control.commands.localization.AddLocalizationsCmd;
import org.mbari.vcr4j.remote.control.commands.localization.Localization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalizationDemo01 {
    private static final Logger log = LoggerFactory.getLogger(LocalizationDemo01.class);

    public static void main(String[] args) throws Exception {
        String prog = TestCommands01.class.getName();
        String doc = "Usage: %s <port> <url>\nOptions:\n  -h, --help\n".formatted(prog);
        Map opts = new Docopt(doc).parse(args);
        int port = Integer.parseInt((String)opts.get("<port>"));
        URL url = new URL((String)opts.get("<url>"));
        UUID uuid = UUID.randomUUID();
        RemoteControl io = (RemoteControl)new RemoteControl.Builder(uuid).port(5555).remotePort(port).remoteHost("localhost").build().get();
        io.getVideoIO().getErrorObservable().subscribe(e -> log.atError().log(() -> ((RError)e).toString()));
        io.getVideoIO().getResponseSubject().subscribe(cr -> {
            String c = cr.command().getName();
            String r = cr.response().getResponse();
            if (!r.equalsIgnoreCase(c)) {
                log.atWarn().log("WARNING command '{}' does not equal response '{}'", (Object)c, (Object)r);
            }
            log.atInfo().log("OK: cmd: {} --- response: {}", (Object)c, (Object)r);
        }, err -> log.atError().setCause(err).log("ERROR"), () -> log.atInfo().log("DONE"));
        List<Localization> locs = AppArgs.buildLocalizations(200, 1200000L, 1920, 1080);
        List<VideoCommands> commands = List.of(new OpenCmd(uuid, url), new AddLocalizationsCmd(uuid, locs), VideoCommands.PLAY);
        Thread.sleep(1000L);
        for (VideoCommand videoCommand : commands) {
            io.getVideoIO().send(videoCommand);
            Thread.sleep(5000L);
        }
        Thread.sleep(1000L);
        io.close();
    }
}

