/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.examples.remote;

import java.io.File;
import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.UUID;
import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.commands.RemoteCommands;
import org.mbari.vcr4j.commands.SeekElapsedTimeCmd;
import org.mbari.vcr4j.commands.ShuttleCmd;
import org.mbari.vcr4j.commands.VideoCommands;
import org.mbari.vcr4j.examples.remote.AppArgs;
import org.mbari.vcr4j.remote.control.RemoteControl;
import org.mbari.vcr4j.remote.control.commands.FrameCaptureCmd;
import org.mbari.vcr4j.remote.control.commands.OpenCmd;
import org.mbari.vcr4j.remote.control.commands.PlayCmd;

public class TestCommands01 {
    public static void main(String[] args) throws Exception {
        AppArgs appArgs = AppArgs.parse(args, TestCommands01.class.getName());
        RemoteControl io = appArgs.remoteControl();
        UUID uuid = appArgs.getVideoUuid();
        URL url = appArgs.url();
        io.getVideoIO().getResponseSubject().subscribe(cr -> {
            String c = cr.command().getName();
            String r = cr.response().getResponse();
            if (!r.equalsIgnoreCase(c)) {
                System.out.println("WARNING command '%s' does not equal response '%s'");
            }
            System.out.printf("%s --- %s%n", cr.command().getName(), cr.response().getResponse());
        }, err -> System.out.println(), () -> System.out.println("DONE"));
        List<VideoCommand> commands = List.of(new OpenCmd(uuid, url), VideoCommands.PLAY, VideoCommands.FAST_FORWARD, VideoCommands.REWIND, VideoCommands.PAUSE, VideoCommands.PLAY, VideoCommands.REQUEST_ELAPSED_TIME, VideoCommands.REQUEST_INDEX, VideoCommands.REQUEST_STATUS, VideoCommands.REQUEST_DEVICE_TYPE, VideoCommands.REQUEST_TIMECODE, VideoCommands.REQUEST_TIMESTAMP, RemoteCommands.FRAMEADVANCE, RemoteCommands.REQUEST_ALL_VIDEO_INFOS, RemoteCommands.REQUEST_VIDEO_INFO, RemoteCommands.SHOW, new PlayCmd(uuid, Double.valueOf(-2.0)), new PlayCmd(uuid, Double.valueOf(-2.0)), new ShuttleCmd(0.02), new ShuttleCmd(-0.02), new SeekElapsedTimeCmd(Duration.ofMillis(1000L)), new PlayCmd(uuid, Double.valueOf(0.01)), new SeekElapsedTimeCmd(Duration.ofMillis(10000L)), new PlayCmd(uuid, Double.valueOf(0.01)), new FrameCaptureCmd(uuid, UUID.randomUUID(), new File("trashme" + String.valueOf(Instant.now()) + ".png").getAbsolutePath()), new SeekElapsedTimeCmd(Duration.ofMillis(1000L)), new PlayCmd(uuid, Double.valueOf(0.01)), new OpenCmd(uuid, url), RemoteCommands.CLOSE);
        Thread.sleep(1000L);
        for (VideoCommand cmd : commands) {
            io.getVideoIO().send(cmd);
            Thread.sleep(1000L);
        }
        Thread.sleep(1000L);
        io.close();
    }
}

