/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.javafx;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.subjects.PublishSubject;
import io.reactivex.rxjava3.subjects.Subject;
import javafx.scene.media.MediaPlayer;
import javafx.util.Duration;
import org.mbari.vcr4j.SimpleVideoError;
import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.VideoIO;
import org.mbari.vcr4j.VideoIndex;
import org.mbari.vcr4j.commands.SeekElapsedTimeCmd;
import org.mbari.vcr4j.commands.ShuttleCmd;
import org.mbari.vcr4j.commands.VideoCommands;
import org.mbari.vcr4j.javafx.JFXVideoState;

public class JFXVideoIO
implements VideoIO<JFXVideoState, SimpleVideoError> {
    public static final double MAX_RATE = 8.0;
    private static final double eps = 0.1;
    public static final double FAST_FORWARD_RATE = 3.0;
    private final Subject<VideoCommand<?>> commandSubject;
    private final Subject<SimpleVideoError> errorObservable;
    private final Subject<VideoIndex> indexObservable;
    private final Subject<JFXVideoState> stateObservable;
    private final MediaPlayer mediaPlayer;

    public JFXVideoIO(MediaPlayer mediaPlayer) {
        this.mediaPlayer = mediaPlayer;
        PublishSubject s1 = PublishSubject.create();
        this.commandSubject = s1.toSerialized();
        PublishSubject s2 = PublishSubject.create();
        this.errorObservable = s2.toSerialized();
        PublishSubject s3 = PublishSubject.create();
        this.indexObservable = s3.toSerialized();
        PublishSubject s4 = PublishSubject.create();
        this.stateObservable = s4.toSerialized();
        this.commandSubject.filter(vc -> vc.equals(VideoCommands.REQUEST_INDEX) || vc.equals(VideoCommands.REQUEST_ELAPSED_TIME)).forEach(vc -> this.requestCurrentTime());
        this.commandSubject.ofType(ShuttleCmd.class).filter(vc -> (Double)vc.getValue() >= 0.0).forEach(vc -> this.playAtRate((Double)vc.getValue() * 8.0));
        this.commandSubject.filter(vc -> vc.equals(VideoCommands.PLAY)).forEach(vc -> this.playAtRate(1.0));
        this.commandSubject.filter(vc -> vc.equals(VideoCommands.REQUEST_STATUS)).forEach(vc -> this.requestStatus());
        this.commandSubject.filter(vc -> vc.equals(VideoCommands.FAST_FORWARD)).forEach(vc -> this.playAtRate(3.0));
        this.commandSubject.filter(vc -> vc.equals(VideoCommands.PAUSE) || vc.equals(VideoCommands.STOP)).forEach(vc -> mediaPlayer.pause());
        this.commandSubject.ofType(SeekElapsedTimeCmd.class).forEach(vc -> this.seekDuration((java.time.Duration)vc.getValue()));
    }

    public void close() {
        this.commandSubject.onComplete();
        this.errorObservable.onComplete();
        this.indexObservable.onComplete();
        this.stateObservable.onComplete();
    }

    public <A extends VideoCommand<?>> void send(A videoCommand) {
        this.commandSubject.onNext(videoCommand);
    }

    public Subject<VideoCommand<?>> getCommandSubject() {
        return this.commandSubject;
    }

    public String getConnectionID() {
        return this.mediaPlayer.getMedia().getSource();
    }

    public Observable<SimpleVideoError> getErrorObservable() {
        return this.errorObservable;
    }

    public Observable<JFXVideoState> getStateObservable() {
        return this.stateObservable;
    }

    public Observable<VideoIndex> getIndexObservable() {
        return this.indexObservable;
    }

    public Subject<VideoIndex> getIndexSubject() {
        return this.indexObservable;
    }

    public MediaPlayer getMediaPlayer() {
        return this.mediaPlayer;
    }

    public void requestCurrentTime() {
        Duration currentTime = this.mediaPlayer.getCurrentTime();
        java.time.Duration duration = java.time.Duration.ofMillis((long)currentTime.toMillis());
        this.indexObservable.onNext((Object)new VideoIndex(duration));
    }

    private void requestStatus() {
        double currentRate = this.mediaPlayer.getCurrentRate();
        boolean fastForward = currentRate > 1.0;
        boolean stopped = Math.abs(currentRate) <= 0.1;
        boolean playing = Math.abs(currentRate - 1.0) <= 0.1;
        boolean shuttling = !playing && currentRate > 0.0;
        this.stateObservable.onNext((Object)new JFXVideoState(fastForward, shuttling, stopped, playing));
    }

    private void seekDuration(java.time.Duration duration) {
        Duration jfxDuration = Duration.millis((double)duration.toMillis());
        this.mediaPlayer.seek(jfxDuration);
    }

    private void playAtRate(double rate) {
        this.mediaPlayer.pause();
        this.mediaPlayer.setRate(rate);
        this.mediaPlayer.play();
    }
}

