/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.javafx.decorators;

import java.time.Duration;
import java.util.Optional;
import javafx.scene.media.MediaPlayer;
import org.mbari.vcr4j.VideoIndex;
import org.mbari.vcr4j.commands.SeekElapsedTimeCmd;
import org.mbari.vcr4j.commands.SeekTimecodeCmd;
import org.mbari.vcr4j.commands.VideoCommands;
import org.mbari.vcr4j.decorators.Decorator;
import org.mbari.vcr4j.javafx.JFXVideoIO;
import org.mbari.vcr4j.time.Timecode;

public class FauxTimecodeDecorator
implements Decorator {
    public FauxTimecodeDecorator(JFXVideoIO io) {
        io.getCommandSubject().filter(vc -> vc.equals(VideoCommands.REQUEST_TIMECODE)).forEach(vc -> {
            MediaPlayer mediaPlayer = io.getMediaPlayer();
            Duration elapsedTime = Duration.ofMillis((long)mediaPlayer.getCurrentTime().toMillis());
            Timecode timecode = this.durationToTimecode(elapsedTime);
            io.getIndexSubject().onNext((Object)new VideoIndex(Optional.empty(), Optional.of(elapsedTime), Optional.of(timecode)));
        });
        io.getCommandSubject().ofType(SeekTimecodeCmd.class).filter(vc -> ((Timecode)vc.getValue()).isValid()).forEach(vc -> {
            Duration elapsedTime = this.timecodeToDuration((Timecode)vc.getValue());
            io.getCommandSubject().onNext((Object)new SeekElapsedTimeCmd(elapsedTime));
        });
    }

    public void unsubscribe() {
    }

    private Timecode durationToTimecode(Duration duration) {
        return new Timecode((double)duration.toMillis() / 10.0, 100.0);
    }

    private Duration timecodeToDuration(Timecode timecode) {
        Timecode newTimecode = new Timecode(timecode.toString(), 100.0);
        return Duration.ofMillis(Math.round(newTimecode.getSeconds() * 1000.0));
    }
}

