/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.jserialcomm;

import com.fazecast.jSerialComm.SerialPort;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.mbari.vcr4j.rs422.RS422Exception;
import org.mbari.vcr4j.rs422.RS422ResponseParser;
import org.mbari.vcr4j.rs422.RS422State;
import org.mbari.vcr4j.rs422.RS422VideoIO;
import org.mbari.vcr4j.util.Preconditions;

public class SerialCommVideoIO
extends RS422VideoIO {
    public static final long IO_DELAY = 10L;
    public static final long RECEIVE_TIMEOUT = 40L;
    private final System.Logger log = System.getLogger(((Object)((Object)this)).getClass().getName());
    private SerialPort serialPort;

    public SerialCommVideoIO(SerialPort serialPort, InputStream inputStream, OutputStream outputStream) {
        super(inputStream, outputStream, 10L);
        Preconditions.checkArgument((serialPort != null ? 1 : 0) != 0, (String)"SerialPort can not be null");
        this.serialPort = serialPort;
    }

    public String getConnectionID() {
        return this.serialPort.getSystemPortName();
    }

    public void close() {
        block4: {
            if (this.serialPort != null) {
                this.log.log(System.Logger.Level.INFO, "Closing serial port:" + this.serialPort.getSystemPortName());
                try {
                    this.getCommandSubject().onComplete();
                    this.getOutputStream().close();
                    this.getInputStream().close();
                    if (this.serialPort.isOpen()) {
                        this.serialPort.closePort();
                    }
                    RS422ResponseParser responseParser = this.getResponseParser();
                    responseParser.getStatusObservable().onNext((Object)RS422State.STOPPED);
                    responseParser.getStatusObservable().onComplete();
                    responseParser.getTimecodeObservable().onComplete();
                    responseParser.getErrorObservable().onComplete();
                    responseParser.getUserbitsObservable().onComplete();
                    this.serialPort = null;
                }
                catch (Exception e) {
                    if (this.serialPort == null) break block4;
                    this.log.log(System.Logger.Level.ERROR, () -> "Problem occured when closing serial port communications on " + this.serialPort.getSystemPortName());
                }
            }
        }
    }

    public static SerialCommVideoIO open(String portName) {
        System.Logger slog = System.getLogger(SerialCommVideoIO.class.getName());
        slog.log(System.Logger.Level.INFO, "Opening serial port: " + portName);
        SerialPort serialPort = null;
        try {
            serialPort = SerialPort.getCommPort((String)portName);
            if (!serialPort.isOpen()) {
                serialPort.openPort();
            }
            serialPort.setBaudRate(38400);
            serialPort.setComPortTimeouts(257, 100, 0);
            serialPort.setNumDataBits(8);
            serialPort.setParity(1);
            serialPort.setNumStopBits(1);
            serialPort.setFlowControl(1);
            InputStream inputStream = serialPort.getInputStream();
            OutputStream outputStream = serialPort.getOutputStream();
            return new SerialCommVideoIO(serialPort, inputStream, outputStream);
        }
        catch (Exception e) {
            slog.log(System.Logger.Level.WARNING, "Failed to open " + portName, (Throwable)e);
            if (serialPort != null && serialPort.isOpen()) {
                serialPort.closePort();
            }
            throw new RS422Exception("Failed to open " + portName, (Throwable)e);
        }
    }

    public static Set<String> getAvailableSerialPorts() {
        SerialPort[] ports = SerialPort.getCommPorts();
        HashSet<String> portNames = new HashSet<String>();
        SerialPort[] serialPortArray = ports;
        int n = ports.length;
        int n2 = 0;
        while (n2 < n) {
            SerialPort port = serialPortArray[n2];
            try {
                port.openPort();
                port.closePort();
                portNames.add(port.getSystemPortName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        return portNames;
    }

    public static List<String> getSerialPorts() {
        return Arrays.stream(SerialPort.getCommPorts()).map(SerialPort::getSystemPortName).sorted().collect(Collectors.toList());
    }
}

