/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.jssc;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.subjects.PublishSubject;
import io.reactivex.rxjava3.subjects.Subject;
import java.time.Instant;
import java.util.Arrays;
import java.util.Optional;
import jssc.SerialPort;
import jssc.SerialPortException;
import jssc.SerialPortTimeoutException;
import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.VideoIndex;
import org.mbari.vcr4j.commands.VideoCommands;
import org.mbari.vcr4j.rs422.LoggerHelper;
import org.mbari.vcr4j.rs422.RS422Error;
import org.mbari.vcr4j.rs422.RS422Exception;
import org.mbari.vcr4j.rs422.RS422ResponseParser;
import org.mbari.vcr4j.rs422.RS422State;
import org.mbari.vcr4j.rs422.RS422Timecode;
import org.mbari.vcr4j.rs422.RS422Userbits;
import org.mbari.vcr4j.rs422.VCRVideoIO;
import org.mbari.vcr4j.rs422.commands.CommandToBytes;
import org.mbari.vcr4j.rs422.commands.RS422ByteCommands;
import org.mbari.vcr4j.rs422.commands.RS422VideoCommands;

public class JSSCVideoIO
implements VCRVideoIO {
    public static final long IO_DELAY = 10L;
    private final long ioDelay;
    private final RS422ResponseParser responseParser = new RS422ResponseParser();
    private final Subject<VideoCommand<?>> commandSubject;
    public static final int RECEIVE_TIMEOUT = 500;
    private final System.Logger log = System.getLogger(this.getClass().getName());
    private final LoggerHelper loggerHelper = new LoggerHelper(this.log);
    private SerialPort serialPort;

    public JSSCVideoIO(SerialPort serialPort, long ioDelay) {
        this.serialPort = serialPort;
        this.ioDelay = ioDelay;
        PublishSubject s1 = PublishSubject.create();
        this.commandSubject = s1.toSerialized();
        this.commandSubject.subscribe(vc -> {
            byte[] cmd;
            if (vc.equals(RS422VideoCommands.REQUEST_USERBITS)) {
                this.send(RS422VideoCommands.REQUEST_LUSERBITS);
                this.send(RS422VideoCommands.REQUEST_VUSERBITS);
            } else if (!(vc.equals(VideoCommands.REQUEST_TIMESTAMP) || vc.equals(VideoCommands.REQUEST_ELAPSED_TIME) || Arrays.equals(cmd = CommandToBytes.apply((VideoCommand)vc), RS422ByteCommands.UNDEFINED.getBytes()))) {
                this.sendCommand(cmd, (VideoCommand<?>)vc);
            }
        });
    }

    public <A extends VideoCommand<?>> void send(A videoCommand) {
        this.commandSubject.onNext(videoCommand);
    }

    protected synchronized void sendCommand(byte[] command, VideoCommand<?> videoCommand) {
        byte checksum;
        command[command.length - 1] = checksum = RS422ResponseParser.calculateChecksum((byte[])command);
        try {
            this.loggerHelper.logCommand(command, videoCommand);
            this.serialPort.writeBytes(command);
            Thread.sleep(this.ioDelay);
            this.readResponse(command, videoCommand);
        }
        catch (SerialPortException | RS422Exception e) {
            this.log.log(System.Logger.Level.ERROR, "Failed to send a command to the VCR", e);
        }
        catch (InterruptedException e) {
            this.log.log(System.Logger.Level.ERROR, "Thread " + Thread.currentThread().getName() + " was interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (SerialPortTimeoutException e) {
            this.log.log(System.Logger.Level.ERROR, "Serial port timed out", (Throwable)e);
        }
    }

    protected synchronized void readResponse(byte[] mostRecentCommand, VideoCommand videoCommand) throws SerialPortException, RS422Exception, InterruptedException, SerialPortTimeoutException {
        byte[] cmd = this.serialPort.readBytes(2, 500);
        Thread.sleep(this.ioDelay);
        int numDataBytes = cmd[0] & 0xF;
        byte[] data = numDataBytes > 0 ? this.serialPort.readBytes(numDataBytes, 500) : null;
        Thread.sleep(this.ioDelay);
        byte[] checksum = this.serialPort.readBytes(1, 500);
        this.loggerHelper.logResponse(cmd, data, checksum);
        this.responseParser.update(mostRecentCommand, cmd, data, checksum, videoCommand);
    }

    public static JSSCVideoIO open(String portName) {
        try {
            SerialPort serialPort = new SerialPort(portName);
            serialPort.openPort();
            return new JSSCVideoIO(serialPort, 10L);
        }
        catch (Exception e) {
            throw new RS422Exception("Failed to open " + portName, (Throwable)e);
        }
    }

    public void close() {
        block2: {
            this.log.log(System.Logger.Level.INFO, "Closing serial port:" + this.serialPort.getPortName());
            try {
                this.getCommandSubject().onComplete();
                this.serialPort.closePort();
                this.responseParser.getStatusObservable().onNext((Object)RS422State.STOPPED);
                this.responseParser.getStatusObservable().onComplete();
                this.responseParser.getTimecodeObservable().onComplete();
                this.responseParser.getErrorObservable().onComplete();
                this.responseParser.getUserbitsObservable().onComplete();
                this.serialPort = null;
            }
            catch (Exception e) {
                if (!this.log.isLoggable(System.Logger.Level.ERROR) || this.serialPort == null) break block2;
                this.log.log(System.Logger.Level.ERROR, "Problem occured when closing serial port communications on " + this.serialPort.getPortName());
            }
        }
    }

    public String getConnectionID() {
        return null;
    }

    public Subject<VideoCommand<?>> getCommandSubject() {
        return this.commandSubject;
    }

    public Observable<RS422Error> getErrorObservable() {
        return this.responseParser.getErrorObservable();
    }

    public Observable<VideoIndex> getIndexObservable() {
        return Observable.combineLatest((ObservableSource)this.responseParser.getTimecodeObservable(), (ObservableSource)this.responseParser.getStatusObservable(), (timecode, state) -> {
            if (state.isRecording()) {
                return new VideoIndex(Optional.of(Instant.now()), Optional.empty(), Optional.of(timecode.getTimecode()));
            }
            return new VideoIndex(Optional.empty(), Optional.empty(), Optional.of(timecode.getTimecode()));
        }).distinctUntilChanged();
    }

    public Observable<RS422State> getStateObservable() {
        return this.responseParser.getStatusObservable();
    }

    public Observable<RS422Timecode> getTimecodeObservable() {
        return this.responseParser.getTimecodeObservable();
    }

    public Observable<RS422Userbits> getUserbitsObservable() {
        return this.responseParser.getUserbitsObservable();
    }
}

