/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.purejavacomm;

import java.io.InputStream;
import java.io.OutputStream;
import org.mbari.vcr4j.rs422.RS422Exception;
import org.mbari.vcr4j.rs422.RS422ResponseParser;
import org.mbari.vcr4j.rs422.RS422State;
import org.mbari.vcr4j.rs422.RS422VideoIO;
import org.mbari.vcr4j.util.Preconditions;
import purejavacomm.CommPortIdentifier;
import purejavacomm.NoSuchPortException;
import purejavacomm.PortInUseException;
import purejavacomm.SerialPort;
import purejavacomm.UnsupportedCommOperationException;

public class PJCVideoIO
extends RS422VideoIO {
    public static final long IO_DELAY = 100L;
    public static final long RECEIVE_TIMEOUT = 400L;
    private final System.Logger log = System.getLogger(((Object)((Object)this)).getClass().getName());
    private SerialPort serialPort;

    public PJCVideoIO(SerialPort serialPort, InputStream inputStream, OutputStream outputStream) {
        super(inputStream, outputStream, 100L);
        Preconditions.checkArgument((serialPort != null ? 1 : 0) != 0, (String)"SerialPort can not be null");
        this.serialPort = serialPort;
    }

    public void close() {
        block2: {
            this.log.log(System.Logger.Level.INFO, "Closing serial port:" + this.serialPort.getName());
            try {
                this.getCommandSubject().onComplete();
                this.getOutputStream().close();
                this.getInputStream().close();
                this.serialPort.close();
                RS422ResponseParser responseParser = this.getResponseParser();
                responseParser.getStatusObservable().onNext((Object)RS422State.STOPPED);
                responseParser.getStatusObservable().onComplete();
                responseParser.getTimecodeObservable().onComplete();
                responseParser.getErrorObservable().onComplete();
                responseParser.getUserbitsObservable().onComplete();
                this.serialPort = null;
            }
            catch (Exception e) {
                if (!this.log.isLoggable(System.Logger.Level.ERROR) || this.serialPort == null) break block2;
                this.log.log(System.Logger.Level.ERROR, "Problem occured when closing serial port communications on " + this.serialPort.getName());
            }
        }
    }

    public static PJCVideoIO open(String portName) {
        try {
            SerialPort serialPort = PJCVideoIO.openSerialPort(portName);
            InputStream inputStream = serialPort.getInputStream();
            OutputStream outputStream = serialPort.getOutputStream();
            return new PJCVideoIO(serialPort, inputStream, outputStream);
        }
        catch (Exception e) {
            throw new RS422Exception("Failed to open " + portName, (Throwable)e);
        }
    }

    public static SerialPort openSerialPort(String serialPortName) throws NoSuchPortException, PortInUseException, UnsupportedCommOperationException {
        CommPortIdentifier portId = CommPortIdentifier.getPortIdentifier((String)serialPortName);
        SerialPort serialPort = (SerialPort)portId.open("VCR", 2000);
        serialPort.setSerialPortParams(38400, 8, 1, 1);
        serialPort.setFlowControlMode(1);
        serialPort.enableReceiveTimeout(400);
        return serialPort;
    }

    public String getConnectionID() {
        return this.serialPort.getName();
    }
}

