/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.rs422;

import java.util.Arrays;
import org.mbari.vcr4j.rs422.commands.CommandToBytes;
import org.mbari.vcr4j.time.Converters;
import org.mbari.vcr4j.time.HMSF;
import org.mbari.vcr4j.time.Timecode;
import org.mbari.vcr4j.util.Preconditions;

public class RS422Timecode {
    public static final RS422Timecode ZERO = new RS422Timecode(CommandToBytes.timecodeToBytes(new Timecode("00:00:00:00")));
    public static final byte[] ALT_LTC_TIMECODE = new byte[]{116, 20};
    public static final byte[] LTC_TIMECODE = new byte[]{116, 4};
    public static final byte[] TIMER1_TIMECODE = new byte[]{116, 0};
    public static final byte[] TIMER2_TIMECODE = new byte[]{116, 1};
    public static final byte[] VTC_TIMECODE = new byte[]{116, 6};
    private final byte[] timecodeBytes;
    private final Timecode timecode;

    public RS422Timecode(byte[] timecodeBytes) {
        Preconditions.checkArgument((timecodeBytes != null ? 1 : 0) != 0, (String)"timecodeBytes arg can not be null");
        this.timecodeBytes = timecodeBytes;
        HMSF hmsf = new HMSF(RS422Timecode.byteToHourOrFrame(timecodeBytes[3]), RS422Timecode.byteToMinuteOrSecond(timecodeBytes[2]), RS422Timecode.byteToMinuteOrSecond(timecodeBytes[1]), RS422Timecode.byteToHourOrFrame(timecodeBytes[0]));
        this.timecode = Converters.toTimecode((HMSF)hmsf);
    }

    public static int byteToHourOrFrame(byte b) {
        int i10 = ((b & 0x30) >>> 4) * 10;
        int i1 = b & 0xF;
        return i10 + i1;
    }

    public static int byteToMinuteOrSecond(byte b) {
        int i10 = ((b & 0x70) >>> 4) * 10;
        int i1 = b & 0xF;
        return i10 + i1;
    }

    public static int byteToTime(byte b) {
        int i10 = ((b & 0x70) >>> 4) * 10;
        int i1 = b & 0xF;
        return i10 + i1;
    }

    public static byte timeToByte(int i) {
        int i10 = (int)Math.floor(i / 10);
        int i1 = i - i10 * 10;
        byte b10 = (byte)i10;
        byte b1 = (byte)i1;
        return (byte)((b10 << 4) + b1);
    }

    public String toString() {
        return this.getTimecode().toString();
    }

    public Timecode getTimecode() {
        return this.timecode;
    }

    public byte[] getTimecodeBytes() {
        return this.timecodeBytes;
    }

    public static boolean isTimecodeReply(byte[] cmd) {
        return Arrays.equals(cmd, LTC_TIMECODE) || Arrays.equals(cmd, VTC_TIMECODE) || Arrays.equals(cmd, ALT_LTC_TIMECODE) || Arrays.equals(cmd, TIMER1_TIMECODE) || Arrays.equals(cmd, TIMER2_TIMECODE);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RS422Timecode that = (RS422Timecode)o;
        return Arrays.equals(this.timecodeBytes, that.timecodeBytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.timecodeBytes);
    }
}

