/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.rs422.commands;

public enum RS422ByteCommands {
    UNDEFINED("undefined command", new byte[]{0}),
    DEVICE_TYPE_REQUEST("Request device type", new byte[]{0, 17}),
    EJECT_TAPE("Eject tape", new byte[]{32, 15}),
    FAST_FWD("Fast forward", new byte[]{32, 16}),
    GET_CUEUP_STATUS("Request cueup status", new byte[]{97, 32, 33}),
    GET_LTIMECODE("Request longitudinal timecode", new byte[]{97, 12, 1}),
    GET_LUBTIMECODE("Request longitudinal userbits", new byte[]{97, 12, 16}),
    GET_STATUS("Request status", new byte[]{97, 32, 3}),
    GET_TIMECODE("Request timecode", new byte[]{97, 12, 3}),
    GET_TIMECODE1("Request timecode 1", new byte[]{97, 12, 4}),
    GET_TIMECODE2("Request timecode2", new byte[]{97, 12, 8}),
    GET_VTIMECODE("Request vertical timecode", new byte[]{97, 12, 2}),
    GET_VUBTIMECODE("Request vertical userbits", new byte[]{97, 12, 32}),
    LOCAL_DISABLE("Local disable", new byte[]{0, 12}),
    LOCAL_ENABLE("Local enable", new byte[]{0, 29}),
    PAUSE("Pause", new byte[]{33, 19, 0}),
    PLAY_FWD("Play", new byte[]{32, 1}),
    PRESET_TIMECODE("Preset timecode", new byte[]{68, 4, 0, 0, 0, 0}),
    PRESET_USERBITS("Preset userbits", new byte[]{68, 5, 0, 0, 0, 0}),
    RECORD("Record", new byte[]{32, 2}),
    RELEASE_TAPE("Release tape", new byte[]{32, 4}),
    REWIND("Rewind", new byte[]{32, 32}),
    SHUTTLE_FWD("Shuttle forward", new byte[]{33, 19, 0}),
    SHUTTLE_REV("Shuttle reverse", new byte[]{33, 35, 0}),
    SONY_SEEK_TIMECODE("Seek timecode", new byte[]{36, 49, 0, 0, 0, 0}),
    STOP("Stop", new byte[]{32, 0});

    private final byte[] bytes;
    private final String description;

    private RS422ByteCommands(String description, byte[] bytes) {
        this.description = description;
        this.bytes = bytes;
    }

    public byte[] getBytes() {
        byte[] copy = new byte[this.bytes.length + 1];
        System.arraycopy(this.bytes, 0, copy, 0, this.bytes.length);
        return copy;
    }

    public String getDescription() {
        return this.description;
    }
}

