/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.rs422;

import java.util.Optional;
import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.VideoError;

public class RS422Error
implements VideoError {
    public static final int OTHER_ERROR = 2;
    public static final int CHECKSUM_ERROR = 4;
    public static final int FRAMING_ERROR = 64;
    public static final int OK = 0;
    public static final int OVERRUN_ERROR = 32;
    public static final int PARITY_ERROR = 16;
    public static final int TIMEOUT = 128;
    public static final int UNDEFINED_COMMAND = 1;
    private final int error;
    private final String message;
    private final VideoCommand<?> videoCommand;

    public RS422Error(int error) {
        this(error, null, null);
    }

    public RS422Error(int error, VideoCommand<?> videoCommand) {
        this(error, null, videoCommand);
    }

    public RS422Error(String errorMsg) {
        this(2, errorMsg, null);
    }

    public RS422Error(String errorMsg, VideoCommand<?> videoCommand) {
        this(2, errorMsg, videoCommand);
    }

    public RS422Error(int error, String errorMsg, VideoCommand<?> videoCommand) {
        this.error = error;
        this.message = errorMsg;
        this.videoCommand = videoCommand;
    }

    public boolean isChecksumError() {
        return (this.error & 4) > 0;
    }

    public int getError() {
        return this.error;
    }

    public boolean hasError() {
        return this.error != 0;
    }

    public boolean isFramingError() {
        return (this.error & 0x40) > 0;
    }

    public boolean isOK() {
        return this.error == 0;
    }

    public boolean isOverrunError() {
        return (this.error & 0x20) > 0;
    }

    public boolean isParityError() {
        return (this.error & 0x10) > 0;
    }

    public boolean isTimeout() {
        return (this.error & 0x80) > 0;
    }

    public boolean isUndefinedCommand() {
        return (this.error & 1) > 0;
    }

    public Optional<VideoCommand<?>> getVideoCommand() {
        return Optional.ofNullable(this.videoCommand);
    }

    public String getMessage() {
        return this.message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RS422Error that = (RS422Error)o;
        return this.error == that.error;
    }

    public int hashCode() {
        return this.error;
    }
}

