/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.rs422;

import io.reactivex.rxjava3.subjects.PublishSubject;
import io.reactivex.rxjava3.subjects.Subject;
import java.util.Arrays;
import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.rs422.RS422Error;
import org.mbari.vcr4j.rs422.RS422State;
import org.mbari.vcr4j.rs422.RS422Timecode;
import org.mbari.vcr4j.rs422.RS422Userbits;
import org.mbari.vcr4j.rs422.util.NumberUtilities;

public class RS422ResponseParser {
    public static final byte[] ACK = new byte[]{16, 1};
    public static final byte[] NACK = new byte[]{17, 18};
    private final Subject<RS422Error> errorObservable;
    private final Subject<RS422State> statusObservable;
    private final Subject<RS422Timecode> timecodeObservable;
    private final Subject<RS422Userbits> userbitsObservable;

    public RS422ResponseParser() {
        PublishSubject s1 = PublishSubject.create();
        this.errorObservable = s1.toSerialized();
        PublishSubject s2 = PublishSubject.create();
        this.statusObservable = s2.toSerialized();
        PublishSubject s3 = PublishSubject.create();
        this.timecodeObservable = s3.toSerialized();
        PublishSubject s4 = PublishSubject.create();
        this.userbitsObservable = s4.toSerialized();
    }

    public static byte calculateChecksum(byte[] command) {
        int temp = 0;
        int i = 0;
        while (i < command.length) {
            temp += command[i];
            ++i;
        }
        return (byte)temp;
    }

    public void update(byte[] command, byte[] cmd, byte[] data, byte[] checksum) {
        this.update(command, cmd, data, checksum);
    }

    public void update(byte[] command, byte[] cmd, byte[] data, byte[] checksum, VideoCommand videoCommand) {
        byte commandChecksum = RS422ResponseParser.calculateChecksum(command);
        if (!this.isChecksumOK(cmd, data, checksum)) {
            this.errorObservable.onNext((Object)new RS422Error(4, videoCommand));
        } else if (RS422ResponseParser.isAck(cmd)) {
            this.errorObservable.onNext((Object)new RS422Error(0, videoCommand));
        } else if (RS422Timecode.isTimecodeReply(cmd)) {
            this.timecodeObservable.onNext((Object)new RS422Timecode(data));
        } else if (RS422Userbits.isUserbitsReply(cmd)) {
            this.userbitsObservable.onNext((Object)new RS422Userbits(data));
        } else if (RS422State.isStatusReply(cmd)) {
            this.statusObservable.onNext((Object)new RS422State(NumberUtilities.toLong(data)));
        } else if (RS422ResponseParser.isNack(cmd)) {
            byte nackData = data[0];
            this.errorObservable.onNext((Object)new RS422Error(nackData, videoCommand));
        }
    }

    public static boolean isAck(byte[] cmd) {
        return Arrays.equals(cmd, ACK);
    }

    private boolean isChecksumOK(byte[] cmd, byte[] data, byte[] checksum) {
        boolean OK;
        if (cmd == null) {
            OK = false;
        } else {
            byte checksum2;
            byte[] cmdBlock = data == null || data.length == 0 ? new byte[cmd.length] : new byte[cmd.length + data.length];
            int i = 0;
            while (i < cmd.length) {
                cmdBlock[i] = cmd[i];
                ++i;
            }
            if (data != null && data.length > 0) {
                i = 2;
                while (i < cmdBlock.length) {
                    cmdBlock[i] = data[i - 2];
                    ++i;
                }
            }
            OK = checksum[0] == (checksum2 = RS422ResponseParser.calculateChecksum(cmdBlock));
        }
        return OK;
    }

    public static boolean isNack(byte[] cmd) {
        return Arrays.equals(cmd, NACK);
    }

    public Subject<RS422Error> getErrorObservable() {
        return this.errorObservable;
    }

    public Subject<RS422State> getStatusObservable() {
        return this.statusObservable;
    }

    public Subject<RS422Timecode> getTimecodeObservable() {
        return this.timecodeObservable;
    }

    public Subject<RS422Userbits> getUserbitsObservable() {
        return this.userbitsObservable;
    }
}

