/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.rs422;

import java.util.Arrays;
import org.mbari.vcr4j.VideoState;

public class RS422State
implements VideoState {
    public static final byte[] OTHER_STATUS_REPLY = new byte[]{113, 32};
    public static final byte[] STATUS_REPLY = new byte[]{115, 32};
    public static final long STS_BAD_COMM = 128L;
    public static final long STS_CUE_UP = 65536L;
    public static final long STS_DIRECTION = 4L;
    public static final long STS_FAST_FWD = 1024L;
    public static final long STS_HW_ERROR = 0L;
    public static final long STS_JOG = 0x100000L;
    public static final long STS_LOCAL = 1L;
    public static final long STS_PLAY = 256L;
    public static final long STS_RECORD = 512L;
    public static final long STS_REWIND = 2048L;
    public static final long STS_SERVO_LOCK = 0x800000L;
    public static final long STS_SERVO_REF = 16L;
    public static final long STS_SHUTTLE = 32L;
    public static final long STS_STANDBY = 32768L;
    public static final long STS_STILL = 131072L;
    public static final long STS_STOP = 8192L;
    public static final long STS_TAPE_END = 0x4000000L;
    public static final long STS_TAPE_TROUBLE = 8L;
    public static final long STS_TSO = 0x400000L;
    public static final long STS_UNTHREAD = 0L;
    public static final long STS_VARSPEED = 524288L;
    private static final System.Logger log = System.getLogger(RS422State.class.getName());
    public static final RS422State STOPPED = new RS422State(8192L);
    private final long status;

    public RS422State(long status) {
        this.status = status;
        this.logStatus();
    }

    public boolean isBadCommunication() {
        return (this.status & 0x80L) > 0L;
    }

    public boolean isConnected() {
        return this.status > 0L;
    }

    public boolean isCueingUp() {
        return (this.status & 0x10000L) > 0L;
    }

    public boolean isFastForwarding() {
        return (this.status & 0x400L) > 0L;
    }

    public boolean isHardwareError() {
        return 0L > 0L;
    }

    public boolean isJogging() {
        return (this.status & 0x100000L) > 0L;
    }

    public boolean isLocal() {
        return (this.status & 1L) > 0L;
    }

    public boolean isPlaying() {
        return (this.status & 0x100L) > 0L;
    }

    public boolean isRecording() {
        return (this.status & 0x200L) > 0L;
    }

    public boolean isReverseDirection() {
        return (this.status & 4L) > 0L;
    }

    public boolean isRewinding() {
        return (this.status & 0x800L) > 0L;
    }

    public boolean isServoLock() {
        return (this.status & 0x800000L) > 0L;
    }

    public boolean isServoRef() {
        return (this.status & 0x10L) > 0L;
    }

    public boolean isShuttling() {
        return (this.status & 0x20L) > 0L;
    }

    public boolean isStandingBy() {
        return (this.status & 0x8000L) > 0L;
    }

    public boolean isStill() {
        return (this.status & 0x20000L) > 0L;
    }

    public boolean isStopped() {
        return (this.status & 0x2000L) > 0L;
    }

    public boolean isTapeEnd() {
        return (this.status & 0x4000000L) > 0L;
    }

    public boolean isTapeTrouble() {
        return (this.status & 8L) > 0L;
    }

    public boolean isTso() {
        return (this.status & 0x400000L) > 0L;
    }

    public boolean isUnthreaded() {
        return 0L > 0L;
    }

    public boolean isVarSpeed() {
        return (this.status & 0x80000L) > 0L;
    }

    private void logStatus() {
        if (log.isLoggable(System.Logger.Level.DEBUG)) {
            StringBuilder msg = new StringBuilder("VCR Status >> (");
            if (this.isBadCommunication()) {
                msg.append("BadCommunication ");
            }
            if (this.isCueingUp()) {
                msg.append("CueingUp ");
            }
            if (this.isFastForwarding()) {
                msg.append("FastForarding ");
            }
            if (this.isHardwareError()) {
                msg.append("HardwareError ");
            }
            if (this.isJogging()) {
                msg.append("Jogging ");
            }
            if (this.isLocal()) {
                msg.append("Local ");
            }
            if (this.isPlaying()) {
                msg.append("Playing ");
            }
            if (this.isReverseDirection()) {
                msg.append("ReverseDirection ");
            }
            if (this.isRewinding()) {
                msg.append("Rewinding ");
            }
            if (this.isServoLock()) {
                msg.append("ServoLock ");
            }
            if (this.isServoRef()) {
                msg.append("ServoRef ");
            }
            if (this.isShuttling()) {
                msg.append("Shuttiling ");
            }
            if (this.isStandingBy()) {
                msg.append("StandingBy ");
            }
            if (this.isStill()) {
                msg.append("Still ");
            }
            if (this.isStopped()) {
                msg.append("Stopped ");
            }
            if (this.isTapeEnd()) {
                msg.append("TapeEnd ");
            }
            if (this.isTapeTrouble()) {
                msg.append("TapeTrouble ");
            }
            if (this.isTso()) {
                msg.append("Tso ");
            }
            if (this.isUnthreaded()) {
                msg.append("Unthreaded ");
            }
            if (this.isVarSpeed()) {
                msg.append("VarSpeed ");
            }
            msg.delete(msg.length() - 1, msg.length());
            msg.append(")");
            log.log(System.Logger.Level.DEBUG, msg.toString());
        }
    }

    public static boolean isStatusReply(byte[] cmd) {
        return Arrays.equals(cmd, STATUS_REPLY) || Arrays.equals(cmd, OTHER_STATUS_REPLY);
    }
}

