/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.rs422.commands;

import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.commands.SeekElapsedTimeCmd;
import org.mbari.vcr4j.commands.SeekTimecodeCmd;
import org.mbari.vcr4j.commands.SeekTimestampCmd;
import org.mbari.vcr4j.commands.ShuttleCmd;
import org.mbari.vcr4j.commands.VideoCommands;
import org.mbari.vcr4j.rs422.commands.PresetTimecodeCmd;
import org.mbari.vcr4j.rs422.commands.PresetUserbitsCmd;
import org.mbari.vcr4j.rs422.commands.RS422ByteCommands;
import org.mbari.vcr4j.rs422.commands.RS422VideoCommands;
import org.mbari.vcr4j.rs422.util.NumberUtilities;
import org.mbari.vcr4j.time.HMSF;
import org.mbari.vcr4j.time.Timecode;

public class CommandToBytes {
    private static final System.Logger log = System.getLogger(CommandToBytes.class.getName());
    private static final HMSF HMSF_ZERO = new HMSF(0, 0, 0, 0);

    private CommandToBytes() {
    }

    public static byte[] apply(VideoCommand cmd) {
        byte[] bytes = cmd instanceof VideoCommands ? CommandToBytes.toBytes((VideoCommands)cmd) : (cmd instanceof RS422VideoCommands ? CommandToBytes.toBytes((RS422VideoCommands)cmd) : (cmd instanceof PresetTimecodeCmd ? CommandToBytes.toBytes((PresetTimecodeCmd)cmd) : (cmd instanceof PresetUserbitsCmd ? CommandToBytes.toBytes((PresetUserbitsCmd)cmd) : (cmd instanceof SeekElapsedTimeCmd ? CommandToBytes.toBytes((SeekElapsedTimeCmd)cmd) : (cmd instanceof SeekTimecodeCmd ? CommandToBytes.toBytes((SeekTimecodeCmd)cmd) : (cmd instanceof SeekTimestampCmd ? CommandToBytes.toBytes((SeekTimestampCmd)cmd) : (cmd instanceof ShuttleCmd ? CommandToBytes.toBytes((ShuttleCmd)cmd) : RS422ByteCommands.UNDEFINED.getBytes())))))));
        return bytes;
    }

    public static byte[] toBytes(VideoCommands cmd) {
        byte[] bytes = RS422ByteCommands.UNDEFINED.getBytes();
        switch (cmd) {
            case FAST_FORWARD: {
                bytes = RS422ByteCommands.FAST_FWD.getBytes();
                break;
            }
            case PAUSE: {
                bytes = RS422ByteCommands.PAUSE.getBytes();
                break;
            }
            case PLAY: {
                bytes = RS422ByteCommands.PLAY_FWD.getBytes();
                break;
            }
            case REQUEST_DEVICE_TYPE: {
                bytes = RS422ByteCommands.DEVICE_TYPE_REQUEST.getBytes();
                break;
            }
            case REQUEST_ELAPSED_TIME: {
                log.log(System.Logger.Level.DEBUG, String.format("'%s' is not supported.", cmd.getName()));
                break;
            }
            case REQUEST_INDEX: {
                bytes = RS422ByteCommands.GET_TIMECODE.getBytes();
                break;
            }
            case REQUEST_STATUS: {
                bytes = RS422ByteCommands.GET_STATUS.getBytes();
                break;
            }
            case REQUEST_TIMECODE: {
                bytes = RS422ByteCommands.GET_TIMECODE.getBytes();
                break;
            }
            case REQUEST_TIMESTAMP: {
                break;
            }
            case REWIND: {
                bytes = RS422ByteCommands.REWIND.getBytes();
                break;
            }
            case STOP: {
                bytes = RS422ByteCommands.STOP.getBytes();
            }
        }
        return bytes;
    }

    public static byte[] toBytes(RS422VideoCommands cmd) {
        return cmd.getValue().getBytes();
    }

    public static byte[] toBytes(PresetTimecodeCmd cmd) {
        byte[] bytes = RS422ByteCommands.PRESET_TIMECODE.getBytes();
        byte[] timecode = CommandToBytes.timecodeToBytes((Timecode)cmd.getValue());
        System.arraycopy(timecode, 0, bytes, 2, timecode.length);
        return bytes;
    }

    public static byte[] toBytes(PresetUserbitsCmd cmd) {
        byte[] bytes = RS422ByteCommands.PRESET_USERBITS.getBytes();
        byte[] userbits = (byte[])cmd.getValue();
        System.arraycopy(userbits, 0, bytes, 2, userbits.length);
        return bytes;
    }

    public static byte[] toBytes(SeekElapsedTimeCmd cmd) {
        log.log(System.Logger.Level.DEBUG, String.format("'%s' is not supported.", cmd.getName()));
        return RS422ByteCommands.UNDEFINED.getBytes();
    }

    public static byte[] toBytes(SeekTimecodeCmd cmd) {
        byte[] bytes = RS422ByteCommands.SONY_SEEK_TIMECODE.getBytes();
        byte[] timecode = CommandToBytes.timecodeToBytes((Timecode)cmd.getValue());
        System.arraycopy(timecode, 0, bytes, 2, timecode.length);
        return bytes;
    }

    public static byte[] toBytes(SeekTimestampCmd cmd) {
        log.log(System.Logger.Level.DEBUG, String.format("'%s' is not supported.", cmd.getName()));
        return RS422ByteCommands.UNDEFINED.getBytes();
    }

    public static byte[] toBytes(ShuttleCmd cmd) {
        byte[] bytes;
        int speed = (int)Math.round((Double)cmd.getValue() * 255.0);
        if (speed >= 0) {
            bytes = RS422ByteCommands.SHUTTLE_FWD.getBytes();
        } else {
            speed *= -1;
            bytes = RS422ByteCommands.SHUTTLE_REV.getBytes();
        }
        byte[] byteSpeed = NumberUtilities.toByteArray(speed);
        bytes[2] = byteSpeed[3];
        return bytes;
    }

    public static byte[] timecodeToBytes(Timecode timecode) {
        HMSF hmsf = timecode.getHMSF().orElse(HMSF_ZERO);
        return new byte[]{CommandToBytes.intToTime(hmsf.getFrame()), CommandToBytes.intToTime(hmsf.getSecond()), CommandToBytes.intToTime(hmsf.getMinute()), CommandToBytes.intToTime(hmsf.getHour())};
    }

    public static final String byteArrayToString(byte[] b) {
        StringBuffer sb = new StringBuffer();
        if (b != null) {
            int i = 0;
            while (i < b.length) {
                sb.append(b[i]);
                if (i < b.length - 1) {
                    sb.append(" ");
                }
                ++i;
            }
        }
        return sb.toString();
    }

    public static byte intToTime(int time) {
        double timeD = time;
        int tens = (int)Math.floor(timeD / 10.0) * 10;
        int ones = time - tens;
        return (byte)((tens / 10 << 4) + ones);
    }
}

