/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.rs422.decorators;

import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import org.mbari.vcr4j.VideoIO;
import org.mbari.vcr4j.decorators.LoggingDecorator;
import org.mbari.vcr4j.rs422.RS422Error;
import org.mbari.vcr4j.rs422.RS422State;
import org.mbari.vcr4j.rs422.RS422Timecode;
import org.mbari.vcr4j.rs422.VCRVideoIO;
import org.mbari.vcr4j.rs422.decorators.RS422TimecodeAsString;

public class RS422LoggingDecorator
extends LoggingDecorator<RS422State, RS422Error> {
    private Disposable disposable;
    private Observer<RS422Timecode> timecodeSubscriber = new Observer<RS422Timecode>(){

        public void onComplete() {
            RS422LoggingDecorator.this.log.log(System.Logger.Level.DEBUG, "Timecode observable is closed");
        }

        public void onError(Throwable throwable) {
            RS422LoggingDecorator.this.log.log(System.Logger.Level.DEBUG, "An error occurred in the timecode observable", throwable);
        }

        public void onNext(RS422Timecode timecode) {
            if (RS422LoggingDecorator.this.log.isLoggable(System.Logger.Level.DEBUG)) {
                RS422LoggingDecorator.this.log.log(System.Logger.Level.DEBUG, "Received: " + new RS422TimecodeAsString(timecode).toString());
            }
        }

        public void onSubscribe(Disposable disposable) {
            RS422LoggingDecorator.this.disposable = disposable;
        }
    };

    public RS422LoggingDecorator(VCRVideoIO io) {
        super((VideoIO)io);
        io.getTimecodeObservable().subscribe(this.timecodeSubscriber);
    }

    public void unsubscribe() {
        super.unsubscribe();
        this.disposable.dispose();
    }
}

