/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.rs422.decorators;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.subjects.Subject;
import java.time.Instant;
import java.util.Optional;
import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.VideoIndex;
import org.mbari.vcr4j.commands.VideoCommands;
import org.mbari.vcr4j.decorators.Decorator;
import org.mbari.vcr4j.rs422.VCRVideoIO;
import org.mbari.vcr4j.rs422.commands.RS422VideoCommands;
import org.mbari.vcr4j.rs422.commands.RequestUserbitsAsTimeCmd;
import org.mbari.vcr4j.rs422.util.NumberUtilities;

public class UserbitsAsTimeDecorator
implements Decorator {
    private final Observable<VideoIndex> indexObservable;
    private final Observer<VideoCommand> commandObserver;
    private Disposable disposable;

    public UserbitsAsTimeDecorator(VCRVideoIO io) {
        final Subject commandSubject = io.getCommandSubject();
        this.commandObserver = new Observer<VideoCommand>(){

            public void onComplete() {
            }

            public void onError(Throwable throwable) {
            }

            public void onNext(VideoCommand videoCommand) {
                commandSubject.onNext((Object)VideoCommands.REQUEST_TIMECODE);
                commandSubject.onNext((Object)RS422VideoCommands.REQUEST_USERBITS);
            }

            public void onSubscribe(Disposable disposable) {
                UserbitsAsTimeDecorator.this.disposable = disposable;
            }
        };
        commandSubject.filter(vc -> vc == RequestUserbitsAsTimeCmd.COMMAND || vc == VideoCommands.REQUEST_TIMESTAMP).subscribe(this.commandObserver);
        this.indexObservable = Observable.combineLatest((ObservableSource)io.getIndexObservable(), io.getUserbitsObservable(), (videoIndex, userbits) -> new VideoIndex(Optional.of(UserbitsAsTimeDecorator.userbitsAsInstant(userbits.getUserbits())), videoIndex.getElapsedTime(), videoIndex.getTimecode()));
    }

    public static Instant userbitsAsInstant(byte[] userbits) {
        int epochSeconds = NumberUtilities.toInt(userbits, true);
        return Instant.ofEpochSecond(epochSeconds);
    }

    public Observable<VideoIndex> getIndexObservable() {
        return this.indexObservable;
    }

    public void unsubscribe() {
        this.disposable.dispose();
    }
}

