/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.rs422;

import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.rs422.util.NumberUtilities;

public class LoggerHelper {
    private final System.Logger log;

    public LoggerHelper(System.Logger log) {
        this.log = log;
    }

    public void logCommand(byte[] bytes, VideoCommand<?> videoCommand) {
        this.log.log(System.Logger.Level.DEBUG, () -> "[0x" + NumberUtilities.toHexString(bytes) + "] >>> VCR (" + videoCommand.getName() + ")");
    }

    public void logResponse(byte[] cmd, byte[] data, byte[] checksum) {
        if (this.log.isLoggable(System.Logger.Level.DEBUG)) {
            int dataLength = data == null ? 0 : data.length;
            byte[] c = new byte[cmd.length + dataLength + 1];
            System.arraycopy(cmd, 0, c, 0, cmd.length);
            if (data != null) {
                System.arraycopy(data, 0, c, cmd.length, data.length);
            }
            c[c.length - 1] = checksum[0];
            this.log.log(System.Logger.Level.DEBUG, "[0x" + NumberUtilities.toHexString(c) + "] <<< VCR");
        }
    }
}

