/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.rs422;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.subjects.PublishSubject;
import io.reactivex.rxjava3.subjects.Subject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Instant;
import java.util.Arrays;
import java.util.Optional;
import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.VideoIndex;
import org.mbari.vcr4j.commands.VideoCommands;
import org.mbari.vcr4j.rs422.LoggerHelper;
import org.mbari.vcr4j.rs422.RS422Error;
import org.mbari.vcr4j.rs422.RS422Exception;
import org.mbari.vcr4j.rs422.RS422ResponseParser;
import org.mbari.vcr4j.rs422.RS422State;
import org.mbari.vcr4j.rs422.RS422Timecode;
import org.mbari.vcr4j.rs422.RS422Userbits;
import org.mbari.vcr4j.rs422.VCRVideoIO;
import org.mbari.vcr4j.rs422.commands.CommandToBytes;
import org.mbari.vcr4j.rs422.commands.RS422ByteCommands;
import org.mbari.vcr4j.rs422.commands.RS422VideoCommands;
import org.mbari.vcr4j.rs422.util.NumberUtilities;
import org.mbari.vcr4j.util.Preconditions;

public abstract class RS422VideoIO
implements VCRVideoIO {
    private final long ioDelay;
    private static final System.Logger log = System.getLogger(RS422State.class.getName());
    private final LoggerHelper loggerHelper = new LoggerHelper(log);
    private final RS422ResponseParser responseParser = new RS422ResponseParser();
    private final Subject<VideoCommand<?>> commandSubject;
    private OutputStream outputStream;
    private InputStream inputStream;
    private final Observable<VideoIndex> indexObservable = Observable.combineLatest(this.responseParser.getTimecodeObservable(), this.responseParser.getStatusObservable(), (timecode, state) -> {
        if (state.isRecording()) {
            return new VideoIndex(Optional.of(Instant.now()), Optional.empty(), Optional.of(timecode.getTimecode()));
        }
        return new VideoIndex(Optional.empty(), Optional.empty(), Optional.of(timecode.getTimecode()));
    }).distinctUntilChanged();

    public RS422VideoIO(InputStream inputStream, OutputStream outputStream, long ioDelay) {
        Preconditions.checkArgument((inputStream != null ? 1 : 0) != 0, (String)"InputStream can not be null");
        Preconditions.checkArgument((outputStream != null ? 1 : 0) != 0, (String)"OutputStream can not be null");
        this.inputStream = inputStream;
        this.outputStream = outputStream;
        this.ioDelay = ioDelay;
        PublishSubject s1 = PublishSubject.create();
        this.commandSubject = s1.toSerialized();
        this.commandSubject.subscribe(vc -> {
            byte[] cmd;
            if (vc.equals((Object)RS422VideoCommands.REQUEST_USERBITS)) {
                this.send(RS422VideoCommands.REQUEST_LUSERBITS);
                this.send(RS422VideoCommands.REQUEST_VUSERBITS);
            } else if (!(vc.equals((Object)VideoCommands.REQUEST_TIMESTAMP) || vc.equals((Object)VideoCommands.REQUEST_ELAPSED_TIME) || Arrays.equals(cmd = CommandToBytes.apply(vc), RS422ByteCommands.UNDEFINED.getBytes()))) {
                this.sendCommand(cmd, (VideoCommand<?>)vc);
            }
        });
    }

    protected synchronized void readResponse(byte[] mostRecentCommand, VideoCommand videoCommand) throws IOException, RS422Exception, InterruptedException {
        byte[] cmd = new byte[2];
        if (this.inputStream.available() > 0) {
            this.inputStream.read(cmd);
        }
        Thread.sleep(this.ioDelay);
        int numDataBytes = cmd[0] & 0xF;
        byte[] data = null;
        if (numDataBytes > 0) {
            data = new byte[numDataBytes];
            if (this.inputStream.available() > 0) {
                this.inputStream.read(data);
            } else {
                throw new IOException("Incoming data is missing . byte[] = " + NumberUtilities.toHexString(cmd));
            }
        }
        Thread.sleep(this.ioDelay);
        byte[] checksum = new byte[1];
        if (this.inputStream.available() <= 0) {
            this.responseParser.getErrorObservable().onNext((Object)new RS422Error("Incoming checksum is missing", videoCommand));
            throw new IOException("Incoming checksum is missing. cmd[] =  " + NumberUtilities.toHexString(cmd) + " data[] = " + NumberUtilities.toHexString(data));
        }
        this.inputStream.read(checksum);
        this.loggerHelper.logResponse(cmd, data, checksum);
        this.responseParser.update(mostRecentCommand, cmd, data, checksum, videoCommand);
    }

    public <A extends VideoCommand<?>> void send(A videoCommand) {
        this.commandSubject.onNext(videoCommand);
    }

    protected synchronized void sendCommand(byte[] command, VideoCommand<?> videoCommand) {
        byte checksum;
        command[command.length - 1] = checksum = RS422ResponseParser.calculateChecksum(command);
        try {
            this.loggerHelper.logCommand(command, videoCommand);
            this.outputStream.write(command);
            Thread.sleep(this.ioDelay);
            this.readResponse(command, videoCommand);
        }
        catch (IOException | RS422Exception e) {
            this.responseParser.getErrorObservable().onNext((Object)new RS422Error(1, videoCommand));
            log.log(System.Logger.Level.ERROR, "Failed to send a command to the VCR", (Throwable)e);
        }
        catch (InterruptedException e) {
            log.log(System.Logger.Level.ERROR, "Thread " + Thread.currentThread().getName() + " was interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public Subject<VideoCommand<?>> getCommandSubject() {
        return this.commandSubject;
    }

    public Observable<RS422Error> getErrorObservable() {
        return this.responseParser.getErrorObservable();
    }

    public Observable<VideoIndex> getIndexObservable() {
        return this.indexObservable;
    }

    protected InputStream getInputStream() {
        return this.inputStream;
    }

    protected OutputStream getOutputStream() {
        return this.outputStream;
    }

    protected RS422ResponseParser getResponseParser() {
        return this.responseParser;
    }

    public Observable<RS422State> getStateObservable() {
        return this.responseParser.getStatusObservable();
    }

    @Override
    public Observable<RS422Timecode> getTimecodeObservable() {
        return this.responseParser.getTimecodeObservable();
    }

    @Override
    public Observable<RS422Userbits> getUserbitsObservable() {
        return this.responseParser.getUserbitsObservable();
    }
}

