/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.sharktopoda.client.localization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.mbari.vcr4j.sharktopoda.client.localization.Localization;
import org.mbari.vcr4j.sharktopoda.client.localization.LocalizationController;
import org.mbari.vcr4j.sharktopoda.client.localization.Message;
import org.mbari.vcr4j.util.CollectionUtils;

public class SelectionController {
    private final LocalizationController controller;
    private final ObservableList<Localization> selectedLocalizations = FXCollections.observableArrayList();

    public SelectionController(LocalizationController controller) {
        this.controller = controller;
        controller.getIncoming().ofType(Message.class).filter(msg -> "select".equalsIgnoreCase(msg.getAction())).subscribe(msg -> this.select(msg.getLocalizations(), false));
        controller.getIncoming().ofType(Message.class).filter(msg -> "deselect".equalsIgnoreCase(msg.getAction())).subscribe(msg -> this.deselect(msg.getLocalizations(), false));
    }

    public void select(Collection<Localization> localizations, boolean sendNotify) {
        Collection intersection = CollectionUtils.intersection(localizations, this.controller.getLocalizations());
        this.selectedLocalizations.clear();
        this.selectedLocalizations.addAll(intersection);
        if (sendNotify) {
            this.controller.getOutgoing().onNext((Object)new Message("select", new ArrayList<Localization>(intersection)));
        }
    }

    public void deselect(Collection<Localization> localizations, boolean sendNotify) {
        Collection intersection = CollectionUtils.intersection(localizations, this.controller.getLocalizations());
        this.selectedLocalizations.removeAll(intersection);
        if (sendNotify && !intersection.isEmpty()) {
            this.controller.getOutgoing().onNext((Object)new Message("deselect", new ArrayList<Localization>(intersection)));
        }
    }

    public void clearSelections() {
        this.select(Collections.emptyList(), true);
    }

    public LocalizationController getController() {
        return this.controller;
    }

    public ObservableList<Localization> getSelectedLocalizations() {
        return this.selectedLocalizations;
    }
}

