/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.sharktopoda.client.udp;

import com.google.gson.Gson;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.subjects.Subject;
import java.net.MalformedURLException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.mbari.vcr4j.sharktopoda.client.ClientController;
import org.mbari.vcr4j.sharktopoda.client.model.GenericCommand;
import org.mbari.vcr4j.sharktopoda.client.model.GenericResponse;
import org.mbari.vcr4j.sharktopoda.client.model.Video;
import org.mbari.vcr4j.sharktopoda.client.udp.FramecaptureUdpIO;
import org.mbari.vcr4j.sharktopoda.client.udp.UdpIO;

class CommandService {
    private final ClientController clientController;
    private final Subject<GenericResponse> responseSubject;
    private static final System.Logger log = System.getLogger(CommandService.class.getName());
    private final Gson gson = UdpIO.newGson();
    private final FramecaptureUdpIO framecaptureIO;

    public CommandService(ClientController clientController, Subject<GenericCommand> commandSubject, Subject<GenericResponse> responseSubject) {
        this.clientController = clientController;
        this.responseSubject = responseSubject;
        this.framecaptureIO = new FramecaptureUdpIO(this, (Observable<GenericCommand>)commandSubject);
        commandSubject.subscribe(this::handleCommand);
    }

    public Gson getGson() {
        return this.gson;
    }

    private void handleCommand(GenericCommand cmd) {
        String c;
        switch (c = cmd.getCommand().toLowerCase()) {
            case "connect": {
                break;
            }
            case "open": {
                this.doOpen(cmd);
                break;
            }
            case "close": {
                this.doClose(cmd);
                break;
            }
            case "show": {
                this.doShow(cmd);
                break;
            }
            case "request video information": {
                this.doRequestVideoInfo(cmd);
                break;
            }
            case "request all information": {
                this.doRequestAllVideoInfos(cmd);
                break;
            }
            case "play": {
                this.doPlay(cmd);
                break;
            }
            case "pause": {
                this.doPause(cmd);
                break;
            }
            case "request elapsed time": {
                this.doRequestElapsedTime(cmd);
                break;
            }
            case "request status": {
                this.doRequestStatus(cmd);
                break;
            }
            case "seek elapsed time": {
                this.doSeekElapsedTime(cmd);
                break;
            }
            case "framecapture": {
                break;
            }
            case "frame advance": {
                this.doFrameAdvance(cmd);
                break;
            }
        }
    }

    private void doOpen(GenericCommand cmd) {
        GenericResponse r = new GenericResponse(cmd);
        if (cmd.getUrl() != null && cmd.getUuid() != null) {
            boolean status = this.clientController.open(cmd.getUuid(), cmd.getUrl());
            String statusMessage = status ? "ok" : "failed";
            r.setStatus(statusMessage);
        } else {
            log.log(System.Logger.Level.WARNING, "Bad command: %s", this.gson.toJson((Object)cmd));
            r.setStatus("failed");
        }
        this.responseSubject.onNext((Object)r);
    }

    private void doClose(GenericCommand cmd) {
        GenericResponse r = new GenericResponse();
        if (cmd.getUuid() != null) {
            this.clientController.close(cmd.getUuid());
        }
        this.responseSubject.onNext((Object)r);
    }

    private void doShow(GenericCommand cmd) {
        GenericResponse r = new GenericResponse();
        if (cmd.getUuid() != null) {
            this.clientController.show(cmd.getUuid());
        }
        this.responseSubject.onNext((Object)r);
    }

    private void doRequestVideoInfo(GenericCommand cmd) {
        GenericResponse r = new GenericResponse(cmd);
        Optional<Video> opt = this.clientController.requestVideoInfo();
        opt.ifPresent(e -> {
            r.setUuid(e.getUuid());
            r.setUrl(e.getUrl());
        });
        this.responseSubject.onNext((Object)r);
    }

    private void doRequestAllVideoInfos(GenericCommand cmd) {
        GenericResponse r = new GenericResponse(cmd);
        Video[] videos = (Video[])this.clientController.requestAllVideoInfos().stream().toArray(Video[]::new);
        r.setVideos(videos);
        this.responseSubject.onNext((Object)r);
    }

    private void doPlay(GenericCommand cmd) {
        this.doAction(cmd, genericResponse -> {
            double rate = cmd.getRate() == null ? 1.0 : cmd.getRate();
            boolean ok = this.clientController.play(cmd.getUuid(), rate);
            return ok ? "ok" : "failed";
        });
    }

    private void doPause(GenericCommand cmd) {
        this.doAction(cmd, genericResponse -> {
            boolean ok = this.clientController.pause(cmd.getUuid());
            return ok ? "ok" : "failed";
        });
    }

    private void doRequestElapsedTime(GenericCommand cmd) {
        this.doAction(cmd, genericResponse -> {
            Optional<Duration> opt = this.clientController.requestElapsedTime(cmd.getUuid());
            opt.ifPresent(genericResponse::setElapsedTime);
            return opt.isPresent() ? null : "failed";
        });
    }

    private void doRequestStatus(GenericCommand cmd) {
        this.doAction(cmd, genericResponse -> {
            Optional<Double> opt = this.clientController.requestRate(cmd.getUuid());
            String msg = "failed";
            if (opt.isPresent()) {
                double rate = opt.get();
                msg = rate < 0.001 && rate > -0.001 ? "paused" : (Math.abs(rate - 1.0) < 0.01 ? "playing" : (rate > 0.0 ? "shuttling forward" : "shuttling reverse"));
            }
            return msg;
        });
    }

    private void doSeekElapsedTime(GenericCommand cmd) {
        this.doAction(cmd, genericResponse -> {
            if (cmd.getElapsedTime() != null) {
                boolean ok = this.clientController.seekElapsedTime(cmd.getUuid(), cmd.getElapsedTime());
                genericResponse.setResponse(null);
                return ok ? "ok" : "failed";
            }
            return "failed";
        });
    }

    private void doFrameAdvance(GenericCommand cmd) {
        this.doAction(cmd, genericResponse -> {
            boolean ok = this.clientController.frameAdvance(cmd.getUuid());
            genericResponse.setResponse(null);
            return ok ? "ok" : "failed";
        });
    }

    private void doAction(GenericCommand cmd, Function<GenericResponse, String> fn) {
        GenericResponse r = new GenericResponse(cmd);
        r.setStatus("failed");
        r.setUuid(r.getUuid());
        if (cmd.getUuid() != null) {
            try {
                String status = fn.apply(r);
                r.setStatus(status);
            }
            catch (Exception e) {
                r.setStatus("failed");
                log.log(System.Logger.Level.WARNING, "Failed to execute " + this.gson.toJson((Object)cmd), (Throwable)e);
            }
        } else {
            r.setStatus("failed");
        }
        this.responseSubject.onNext((Object)r);
    }

    protected CompletableFuture<GenericResponse> doFramecapture(GenericCommand cmd) {
        CompletableFuture<GenericResponse> f = new CompletableFuture<GenericResponse>();
        GenericResponse r = new GenericResponse(cmd);
        r.setImageReferenceUuid(cmd.getImageReferenceUuid());
        r.setStatus("failed");
        if (cmd.getUuid() != null && cmd.getImageReferenceUuid() != null && cmd.getImageLocation() != null) {
            Path path = Paths.get(cmd.getImageLocation(), new String[0]);
            ((CompletableFuture)this.clientController.framecapture(cmd.getUuid(), path).thenAccept(fc -> {
                try {
                    String url = fc.getSaveLocation().toUri().toURL().toExternalForm();
                    r.setImageLocation(url);
                }
                catch (MalformedURLException e) {
                    log.log(System.Logger.Level.WARNING, "Unable to parse " + fc.getSaveLocation() + " as a URL");
                    r.setImageLocation(fc.getSaveLocation().toString());
                }
                r.setElapsedTime(fc.getSnapTime());
                r.setStatus("ok");
            })).thenAccept(v -> f.complete(r));
        } else {
            f.completeExceptionally(new RuntimeException("Missing parameters needed to acquire framecapture"));
        }
        return f;
    }
}

