/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.sharktopoda.client.udp;

import com.google.gson.Gson;
import io.reactivex.rxjava3.core.Observable;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.mbari.vcr4j.sharktopoda.client.model.GenericCommand;
import org.mbari.vcr4j.sharktopoda.client.udp.CommandService;

class FramecaptureUdpIO {
    private volatile int remotePort;
    private final Observable<GenericCommand> commandObserver;
    private final CommandService commandService;
    private static final System.Logger log = System.getLogger(FramecaptureUdpIO.class.getName());
    private final Class prefNodeKey = this.getClass();

    public FramecaptureUdpIO(CommandService commandService, Observable<GenericCommand> commandObserver) {
        this.commandObserver = commandObserver;
        this.commandService = commandService;
        this.commandObserver.filter(gc -> gc.getCommand().equals("connect")).subscribe(this::doConnect);
        this.commandObserver.filter(gc -> gc.getCommand().equals("framecapture")).subscribe(this::doFramecapture);
        Preferences prefs = Preferences.userNodeForPackage(this.prefNodeKey);
        this.remotePort = prefs.getInt("framecapturePort", 5000);
    }

    private void doConnect(GenericCommand cmd) {
        Integer port = cmd.getPort();
        if (port != null) {
            this.remotePort = port;
            Preferences prefs = Preferences.userNodeForPackage(this.prefNodeKey);
            prefs.putInt("framecapturePort", port);
            try {
                prefs.flush();
            }
            catch (BackingStoreException e) {
                log.log(System.Logger.Level.WARNING, "Failed to save framecapture port to preferences", (Throwable)e);
            }
        }
    }

    private void doFramecapture(GenericCommand cmd) {
        this.commandService.doFramecapture(cmd).thenAccept(response -> {
            try {
                DatagramSocket socket = new DatagramSocket();
                Gson gson = this.commandService.getGson();
                byte[] data = gson.toJson(response).getBytes();
                log.log(System.Logger.Level.DEBUG, "Sending >>> " + new String(data));
                DatagramPacket packet = new DatagramPacket(data, data.length, cmd.getPacketAddress(), this.remotePort);
                socket.send(packet);
                socket.close();
            }
            catch (Exception e) {
                log.log(System.Logger.Level.WARNING, "Failed to respond about framecapture", (Throwable)e);
            }
        });
    }
}

