/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.sharktopoda.client.localization;

import io.reactivex.rxjava3.core.Observable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;
import org.mbari.vcr4j.sharktopoda.client.IOBus;
import org.mbari.vcr4j.sharktopoda.client.localization.Localization;
import org.mbari.vcr4j.sharktopoda.client.localization.Message;
import org.mbari.vcr4j.sharktopoda.client.localization.Preconditions;

public class LocalizationController
extends IOBus {
    private final ObservableList<Localization> localizations = FXCollections.observableArrayList();
    private final Comparator<Localization> elapsedTimeComparator = Comparator.comparing(Localization::getElapsedTime);
    private final ObservableList<Localization> readOnlyLocalizations = new SortedList(FXCollections.unmodifiableObservableList(this.localizations), this.elapsedTimeComparator);
    private static final System.Logger log = System.getLogger(LocalizationController.class.getName());

    public LocalizationController() {
        Observable msgObservable = this.incoming.ofType(Message.class);
        msgObservable.filter(msg -> "add".equalsIgnoreCase(msg.getAction())).map(Message::getLocalizations).subscribe(this::addOrReplaceLocalizationsInternal, e -> log.log(System.Logger.Level.WARNING, "An error occurred on the incoming localization bus", (Throwable)e));
        msgObservable.filter(msg -> "remove".equalsIgnoreCase(msg.getAction())).map(Message::getLocalizations).subscribe(this::removeLocalizationsInternal, e -> log.log(System.Logger.Level.WARNING, "An error occurred on the incoming localization bus", (Throwable)e));
        msgObservable.filter(msg -> "clear".equalsIgnoreCase(msg.getAction())).forEach(msg -> this.localizations.clear());
    }

    public void clear() {
        Message msg = new Message("clear");
        this.incoming.onNext((Object)msg);
        this.outgoing.onNext((Object)msg);
    }

    public ObservableList<Localization> getLocalizations() {
        return this.readOnlyLocalizations;
    }

    private void addOrReplaceLocalizationsInternal(Collection<Localization> xs) {
        for (Localization x : xs) {
            try {
                this.addOrReplaceLocalizationInternal(x);
            }
            catch (IllegalArgumentException e) {
                log.log(System.Logger.Level.WARNING, "Failed to add a localization that was missing required values.", (Throwable)e);
            }
        }
    }

    private void addOrReplaceLocalizationInternal(Localization a) {
        boolean exists = false;
        for (int i = 0; i < this.localizations.size(); ++i) {
            Localization b = (Localization)this.localizations.get(i);
            if (!b.getLocalizationUuid().equals(a.getLocalizationUuid())) continue;
            log.log(System.Logger.Level.DEBUG, "Replacing localization (uuid = " + a.getLocalizationUuid() + ")");
            this.localizations.set(i, (Object)a);
            exists = true;
            break;
        }
        if (!exists) {
            log.log(System.Logger.Level.DEBUG, "Adding localization (uuid = " + a.getLocalizationUuid() + ")");
            this.localizations.add((Object)a);
        }
    }

    public void addLocalization(Localization localization) {
        this.addLocalizations(List.of(localization));
    }

    public void addLocalizations(Collection<Localization> localizations) {
        localizations.forEach(this::validateLocalizationForAdd);
        if (!localizations.isEmpty()) {
            Message msg = new Message("add", new ArrayList<Localization>(localizations));
            this.incoming.onNext((Object)msg);
            this.outgoing.onNext((Object)msg);
        }
    }

    private void validateLocalizationForAdd(Localization localization) {
        Preconditions.require(localization.getLocalizationUuid() != null, "Localization requires a localizationUuid. Null was found.");
        Preconditions.require(localization.getConcept() != null, "A Localization requires a concept. Null was found");
        Preconditions.require(localization.getElapsedTime() != null, "A localization requires an elapsedtime. Null was found");
        Preconditions.require(localization.getX() != null, "A localization requires an x value. Null was found");
        Preconditions.require(localization.getX() >= 0, "A localization can not have a negative x coordinate. " + localization.getX() + " + was found.");
        Preconditions.require(localization.getY() != null, "A localization requires an y value. Null was found");
        Preconditions.require(localization.getY() >= 0, "A localization can not have a negative y coordinate. " + localization.getX() + " + was found.");
        Preconditions.require(localization.getWidth() != null, "A localization requires a width value. Null was found");
        Preconditions.require(localization.getWidth() > 0, "A localization can not have a width less than 1 pixel." + localization.getWidth() + " + was found.");
        Preconditions.require(localization.getHeight() != null, "A localization requires an height value. Null was found");
        Preconditions.require(localization.getHeight() > 0, "A localization can not have a height less than 1 pixel. " + localization.getHeight() + " + was found.");
    }

    public void removeLocalization(Localization localization) {
        this.removeLocalizations(List.of(localization));
    }

    public void removeLocalization(UUID localizationUuid) {
        Preconditions.require(localizationUuid != null, "removeLocalization(null) is not allowed");
        Localization a = new Localization();
        a.setLocalizationUuid(localizationUuid);
        this.removeLocalization(a);
    }

    public void removeLocalizations(Collection<Localization> localizations) {
        localizations.forEach(this::validateLocalizationForRemove);
        Message msg = new Message("remove", new ArrayList<Localization>(localizations));
        this.incoming.onNext((Object)msg);
        this.outgoing.onNext((Object)msg);
    }

    private void validateLocalizationForRemove(Localization localization) {
        Preconditions.require(localization.getLocalizationUuid() != null, "Can not remove a localization without a localizationUuid");
    }

    private void removeLocalizationsInternal(Collection<Localization> xs) {
        for (Localization x : xs) {
            try {
                this.removeLocalizationInternal(x);
            }
            catch (IllegalArgumentException e) {
                log.log(System.Logger.Level.WARNING, "Failed to remove a localization that was missing required values.", (Throwable)e);
            }
        }
    }

    private void removeLocalizationInternal(Localization localization) {
        boolean exists = false;
        Object msg = null;
        for (int i = 0; i < this.localizations.size(); ++i) {
            Localization b = (Localization)this.localizations.get(i);
            if (!b.getLocalizationUuid().equals(localization.getLocalizationUuid())) continue;
            this.localizations.remove(i);
            exists = true;
            break;
        }
        if (!exists) {
            log.log(System.Logger.Level.DEBUG, "A localization with UUID of " + localization.getLocalizationUuid() + " was not found. Unable to remove.");
        }
        if (msg != null) {
            log.log(System.Logger.Level.DEBUG, "Removing localization (uuid = " + localization.getLocalizationUuid() + ")");
        }
    }
}

