/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.sharktopoda.client.udp;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.schedulers.Schedulers;
import io.reactivex.rxjava3.subjects.PublishSubject;
import io.reactivex.rxjava3.subjects.Subject;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.mbari.vcr4j.sharktopoda.client.gson.DurationConverter;
import org.mbari.vcr4j.sharktopoda.client.model.GenericCommand;
import org.mbari.vcr4j.sharktopoda.client.model.GenericResponse;

class UdpIO {
    private final int port;
    private DatagramSocket server;
    private static final System.Logger log = System.getLogger(UdpIO.class.getName());
    private final Thread receiverThread;
    private final Subject<GenericCommand> commandSubject;
    private final Subject<GenericResponse> responseSubject;
    private volatile boolean ok = true;
    private final Gson gson = UdpIO.newGson();
    private final ExecutorService executor = Executors.newSingleThreadExecutor();

    public UdpIO(int port) {
        this.port = port;
        PublishSubject s1 = PublishSubject.create();
        this.commandSubject = s1.toSerialized();
        Scheduler scheduler = Schedulers.from((Executor)this.executor);
        PublishSubject s2 = PublishSubject.create();
        this.responseSubject = s2.toSerialized();
        this.responseSubject.subscribeOn(scheduler).subscribe(this::doResponse);
        this.receiverThread = this.buildReceiverThread();
        this.receiverThread.setDaemon(true);
        this.receiverThread.start();
    }

    public void close() {
        if (this.ok) {
            this.ok = false;
            this.executor.shutdown();
            this.commandSubject.onComplete();
            this.responseSubject.onComplete();
        }
    }

    private void doResponse(GenericResponse response) {
        if (response.isResponseExpected()) {
            try {
                DatagramSocket s = this.getServer();
                byte[] b = this.gson.toJson((Object)response).getBytes();
                log.log(System.Logger.Level.DEBUG, "Sending >>> " + new String(b));
                DatagramPacket packet = new DatagramPacket(b, b.length, response.getPacketAddress(), response.getPacketPort());
                s.send(packet);
            }
            catch (Exception e) {
                log.log(System.Logger.Level.ERROR, "UDP response failed", (Throwable)e);
            }
        }
    }

    private Thread buildReceiverThread() {
        return new Thread(() -> {
            byte[] buffer = new byte[4096];
            DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
            while (this.ok) {
                try {
                    this.getServer().receive(packet);
                    String msg = new String(packet.getData(), 0, packet.getLength());
                    log.log(System.Logger.Level.DEBUG, "Received <<< " + msg);
                    GenericCommand r = (GenericCommand)this.gson.fromJson(msg, GenericCommand.class);
                    r.setPacketAddress(packet.getAddress());
                    r.setPacketPort(packet.getPort());
                    this.commandSubject.onNext((Object)r);
                }
                catch (Exception e) {
                    log.log(System.Logger.Level.INFO, "Error while reading UDP datagram", (Throwable)e);
                    if (!this.server.isClosed()) {
                        this.server.close();
                    }
                    if (this.server == null) continue;
                    this.server = null;
                }
            }
            if (this.server != null) {
                this.server.close();
            }
            log.log(System.Logger.Level.INFO, "Shutting down UDP server");
        });
    }

    private DatagramSocket getServer() throws SocketException {
        if (this.server == null || this.server.isClosed()) {
            this.server = new DatagramSocket(this.port);
        }
        return this.server;
    }

    public static Gson newGson() {
        return new GsonBuilder().setPrettyPrinting().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").registerTypeAdapter(Duration.class, (Object)new DurationConverter()).create();
    }

    public Subject<GenericResponse> getResponseSubject() {
        return this.responseSubject;
    }

    public Subject<GenericCommand> getCommandSubject() {
        return this.commandSubject;
    }
}

