/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.sharktopoda.client.localization;

import com.google.gson.annotations.SerializedName;
import java.time.Duration;
import java.util.UUID;
import org.mbari.vcr4j.sharktopoda.client.localization.Preconditions;

public class Localization {
    private String concept;
    @SerializedName(value="elapsedTimeMillis")
    private Duration elapsedTime;
    @SerializedName(value="durationMillis")
    private Duration duration;
    private UUID videoReferenceUuid;
    private UUID annotationUuid;
    private UUID localizationUuid;
    private Integer x;
    private Integer y;
    private Integer width;
    private Integer height;
    private String sourceId;

    public Localization() {
        this.localizationUuid = UUID.randomUUID();
    }

    public Localization(Localization n) {
        this(n.concept, n.elapsedTime, n.localizationUuid, n.videoReferenceUuid, n.x, n.y, n.width, n.height, n.duration, n.annotationUuid);
        this.videoReferenceUuid = n.videoReferenceUuid;
    }

    public Localization(String concept, Duration elapsedTime, UUID localizationUuid, UUID videoReferenceUuid, Integer x, Integer y, Integer width, Integer height, Duration duration, UUID annotationUuid) {
        Preconditions.require(localizationUuid != null, "The localizationUuid can not be null");
        this.concept = concept;
        this.elapsedTime = elapsedTime;
        this.duration = duration;
        this.annotationUuid = annotationUuid;
        this.localizationUuid = localizationUuid;
        this.videoReferenceUuid = videoReferenceUuid;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public Localization(String concept, Duration elapsedTime, UUID localizationUuid, UUID videoReferenceUuid, Integer x, Integer y, Integer width, Integer height, UUID annotationUuid) {
        this(concept, elapsedTime, localizationUuid, videoReferenceUuid, x, y, width, height, Duration.ZERO, annotationUuid);
    }

    public Localization(String concept, Duration elapsedTime, UUID localizationUuid, UUID videoReferenceUuid, Integer x, Integer y, Integer width, Integer height) {
        this(concept, elapsedTime, localizationUuid, videoReferenceUuid, x, y, width, height, Duration.ZERO, null);
    }

    public Localization(String concept, Duration elapsedTime, UUID localizationUuid, UUID videoReferenceUuid, Integer x, Integer y, Integer width, Integer height, Duration duration) {
        this(concept, elapsedTime, localizationUuid, videoReferenceUuid, x, y, width, height, duration, null);
    }

    public String getConcept() {
        return this.concept;
    }

    public void setConcept(String concept) {
        this.concept = concept;
    }

    public Duration getElapsedTime() {
        return this.elapsedTime;
    }

    public Duration getEndTime() {
        if (this.duration == null) {
            return this.elapsedTime;
        }
        return this.elapsedTime.plus(this.duration);
    }

    public void setElapsedTime(Duration elapsedTime) {
        this.elapsedTime = elapsedTime;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public void setDuration(Duration duration) {
        this.duration = duration;
    }

    public UUID getAnnotationUuid() {
        return this.annotationUuid;
    }

    public void setAnnotationUuid(UUID annotationUuid) {
        this.annotationUuid = annotationUuid;
    }

    public UUID getLocalizationUuid() {
        return this.localizationUuid;
    }

    public void setLocalizationUuid(UUID localizationUuid) {
        Preconditions.require(localizationUuid != null, "The localizationUuid can not be null");
        this.localizationUuid = localizationUuid;
    }

    public Integer getX() {
        return this.x;
    }

    public void setX(Integer x) {
        this.x = x;
    }

    public Integer getY() {
        return this.y;
    }

    public void setY(Integer y) {
        this.y = y;
    }

    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public UUID getVideoReferenceUuid() {
        return this.videoReferenceUuid;
    }

    public void setVideoReferenceUuid(UUID videoReferenceUuid) {
        this.videoReferenceUuid = videoReferenceUuid;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Localization that = (Localization)o;
        return this.localizationUuid.equals(that.localizationUuid);
    }

    public int hashCode() {
        return this.localizationUuid.hashCode();
    }

    public String toString() {
        return "Localization{concept='" + this.concept + "', elapsedTime=" + String.valueOf(this.elapsedTime) + ", localizationUuid=" + String.valueOf(this.localizationUuid) + "}";
    }
}

