/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.sharktopoda.client.model;

import com.google.gson.annotations.SerializedName;
import java.net.InetAddress;
import java.net.URL;
import java.time.Duration;
import java.util.UUID;
import org.mbari.vcr4j.sharktopoda.client.model.GenericCommand;
import org.mbari.vcr4j.sharktopoda.client.model.Video;

public class GenericResponse {
    private String response;
    private String status;
    private UUID uuid;
    private Video[] videos;
    @SerializedName(value="elapsed_time_millis")
    private Duration elapsedTime;
    private UUID imageReferenceUuid;
    private String imageLocation;
    private URL url;
    private transient InetAddress packetAddress;
    private transient int packetPort;

    public GenericResponse() {
    }

    public GenericResponse(GenericCommand cmd) {
        this.packetAddress = cmd.getPacketAddress();
        this.packetPort = cmd.getPacketPort();
        this.response = cmd.getCommand();
        this.uuid = cmd.getUuid();
    }

    public GenericResponse(String response) {
        this.response = response;
    }

    public GenericResponse(GenericCommand cmd, String response) {
        this.packetAddress = cmd.getPacketAddress();
        this.packetPort = cmd.getPacketPort();
        this.response = response;
    }

    public String getResponse() {
        return this.response;
    }

    public void setResponse(String response) {
        this.response = response;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public Video[] getVideos() {
        return this.videos;
    }

    public void setVideos(Video[] videos) {
        this.videos = videos;
    }

    public Duration getElapsedTime() {
        return this.elapsedTime;
    }

    public void setElapsedTime(Duration elapsedTime) {
        this.elapsedTime = elapsedTime;
    }

    public UUID getImageReferenceUuid() {
        return this.imageReferenceUuid;
    }

    public void setImageReferenceUuid(UUID imageReferenceUuid) {
        this.imageReferenceUuid = imageReferenceUuid;
    }

    public String getImageLocation() {
        return this.imageLocation;
    }

    public void setImageLocation(String imageLocation) {
        this.imageLocation = imageLocation;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public boolean isResponseExpected() {
        return this.response != null && !this.response.isEmpty();
    }

    public InetAddress getPacketAddress() {
        return this.packetAddress;
    }

    public void setPacketAddress(InetAddress packetAddress) {
        this.packetAddress = packetAddress;
    }

    public int getPacketPort() {
        return this.packetPort;
    }

    public void setPacketPort(int packetPort) {
        this.packetPort = packetPort;
    }
}

