/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.sharktopoda;

import io.reactivex.rxjava3.subjects.Subject;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.VideoIndex;
import org.mbari.vcr4j.commands.RemoteCommands;
import org.mbari.vcr4j.commands.VideoCommands;
import org.mbari.vcr4j.sharktopoda.Constants;
import org.mbari.vcr4j.sharktopoda.SharktopodaError;
import org.mbari.vcr4j.sharktopoda.SharktopodaState;
import org.mbari.vcr4j.sharktopoda.commands.OpenCmd;
import org.mbari.vcr4j.sharktopoda.model.VideoInformation;
import org.mbari.vcr4j.sharktopoda.model.response.OpenResponse;
import org.mbari.vcr4j.sharktopoda.model.response.PlayResponse;
import org.mbari.vcr4j.sharktopoda.model.response.RequestAllVideoInfosReponse;
import org.mbari.vcr4j.sharktopoda.model.response.RequestElapsedTimeResponse;
import org.mbari.vcr4j.sharktopoda.model.response.RequestStatusResponse;
import org.mbari.vcr4j.sharktopoda.model.response.RequestVideoInfoResponse;

public class SharktopodaResponseParser {
    private final UUID uuid;
    private final Subject<SharktopodaState> stateSubject;
    private final Subject<SharktopodaError> errorSubject;
    private final Subject<VideoIndex> indexSubject;
    private final Subject<VideoInformation> videoInfoSubject;
    private static final System.Logger log = System.getLogger(SharktopodaResponseParser.class.getName());

    public SharktopodaResponseParser(UUID uuid, Subject<SharktopodaState> stateSubject, Subject<SharktopodaError> errorSubject, Subject<VideoIndex> indexSubject, Subject<VideoInformation> videoInfoSubject) {
        this.uuid = uuid;
        this.stateSubject = stateSubject;
        this.errorSubject = errorSubject;
        this.indexSubject = indexSubject;
        this.videoInfoSubject = videoInfoSubject;
    }

    public void parse(VideoCommand<?> command, byte[] response) {
        String msg = new String(response);
        log.log(System.Logger.Level.DEBUG, "Parsing " + String.valueOf(command) + " <<< " + msg);
        try {
            if (command instanceof OpenCmd) {
                this.handleOpen(msg);
            } else if (command.equals((Object)VideoCommands.PLAY)) {
                this.handlePlay(msg);
            } else if (command.equals((Object)VideoCommands.PAUSE) || command.equals((Object)VideoCommands.STOP)) {
                this.handlePause(msg);
            } else if (command.equals((Object)VideoCommands.REQUEST_STATUS)) {
                this.handleRequestStatus(msg);
            } else if (command.equals((Object)VideoCommands.REQUEST_INDEX)) {
                this.handleRequestIndex(msg);
            } else if (command.equals((Object)VideoCommands.REQUEST_ELAPSED_TIME)) {
                this.handleRequestIndex(msg);
            } else if (command.equals((Object)RemoteCommands.REQUEST_VIDEO_INFO)) {
                this.handleRequestVideoInfo(msg);
            } else if (command.equals((Object)RemoteCommands.REQUEST_ALL_VIDEO_INFOS)) {
                this.handleRequestAllVideoInfos(msg);
            }
        }
        catch (Exception e) {
            SharktopodaError error = new SharktopodaError(false, true, false, Optional.of(command));
            this.errorSubject.onNext((Object)error);
        }
    }

    private void handleOpen(String msg) {
        OpenResponse r = (OpenResponse)Constants.GSON.fromJson(msg, OpenResponse.class);
        SharktopodaState state = r.getStatus().equalsIgnoreCase("ok") ? new SharktopodaState(SharktopodaState.State.PAUSED) : new SharktopodaState(SharktopodaState.State.NOT_FOUND);
        this.stateSubject.onNext((Object)state);
    }

    private void handleRequestStatus(String msg) {
        RequestStatusResponse r = (RequestStatusResponse)Constants.GSON.fromJson(msg, RequestStatusResponse.class);
        if (r.getUuid().equals(this.uuid)) {
            SharktopodaState state = SharktopodaState.parse(r.getStatus());
            this.stateSubject.onNext((Object)state);
        }
    }

    private void handlePlay(String msg) {
        PlayResponse r = (PlayResponse)Constants.GSON.fromJson(msg, PlayResponse.class);
        if (r.getStatus().equalsIgnoreCase("ok")) {
            SharktopodaState state = new SharktopodaState(SharktopodaState.State.PLAYING);
            this.stateSubject.onNext((Object)state);
        } else {
            SharktopodaError error = new SharktopodaError(false, true, true, Optional.of(VideoCommands.PLAY));
            this.errorSubject.onNext((Object)error);
        }
    }

    private void handlePause(String msg) {
        PlayResponse r = (PlayResponse)Constants.GSON.fromJson(msg, PlayResponse.class);
        if (r.getStatus().equalsIgnoreCase("ok")) {
            SharktopodaState state = new SharktopodaState(SharktopodaState.State.PAUSED);
            this.stateSubject.onNext((Object)state);
        } else {
            SharktopodaError error = new SharktopodaError(false, false, true, Optional.of(VideoCommands.PAUSE));
            this.errorSubject.onNext((Object)error);
        }
    }

    private void handleRequestIndex(String msg) {
        RequestElapsedTimeResponse r = (RequestElapsedTimeResponse)Constants.GSON.fromJson(msg, RequestElapsedTimeResponse.class);
        if (r.getUuid().equals(this.uuid)) {
            VideoIndex videoIndex = new VideoIndex(Duration.ofMillis(r.getElapsedTimeMillis()));
            this.indexSubject.onNext((Object)videoIndex);
        }
    }

    private void handleRequestVideoInfo(String msg) {
        RequestVideoInfoResponse r = (RequestVideoInfoResponse)Constants.GSON.fromJson(msg, RequestVideoInfoResponse.class);
        if (r.getUuid().equals(this.uuid)) {
            List<VideoInformation.Video> videos = Collections.singletonList(new VideoInformation.Video(r.getUuid(), r.getUrl()));
            VideoInformation info = new VideoInformation(VideoInformation.RequestType.FOCUSED, videos);
            this.videoInfoSubject.onNext((Object)info);
        }
    }

    private void handleRequestAllVideoInfos(String msg) {
        RequestAllVideoInfosReponse r = (RequestAllVideoInfosReponse)Constants.GSON.fromJson(msg, RequestAllVideoInfosReponse.class);
        List<VideoInformation.Video> videos = r.getVideos().stream().map(v -> new VideoInformation.Video(v.getUuid(), v.getUrl())).collect(Collectors.toList());
        VideoInformation info = new VideoInformation(VideoInformation.RequestType.ALL, videos);
        this.videoInfoSubject.onNext((Object)info);
    }
}

