/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.sharktopoda.decorators;

import java.time.Duration;
import java.util.Optional;
import org.mbari.vcr4j.VideoIndex;
import org.mbari.vcr4j.commands.SeekElapsedTimeCmd;
import org.mbari.vcr4j.commands.SeekTimecodeCmd;
import org.mbari.vcr4j.commands.VideoCommands;
import org.mbari.vcr4j.decorators.Decorator;
import org.mbari.vcr4j.sharktopoda.SharktopodaVideoIO;
import org.mbari.vcr4j.time.Timecode;

public class FauxTimecodeDecorator
implements Decorator {
    public FauxTimecodeDecorator(SharktopodaVideoIO io) {
        io.getCommandSubject().filter(vc -> vc.equals((Object)VideoCommands.REQUEST_TIMECODE)).forEach(vc -> io.getCommandSubject().onNext((Object)VideoCommands.REQUEST_ELAPSED_TIME));
        io.getCommandSubject().ofType(SeekTimecodeCmd.class).filter(vc -> ((Timecode)vc.getValue()).isValid()).forEach(vc -> {
            Duration elapsedTime = this.timecodeToDuration((Timecode)vc.getValue());
            io.getCommandSubject().onNext((Object)new SeekElapsedTimeCmd(elapsedTime));
        });
        io.getIndexObservable().filter(vi -> !vi.getTimecode().isPresent() && vi.getElapsedTime().isPresent()).forEach(vi -> {
            Timecode timecode = this.durationToTimecode((Duration)vi.getElapsedTime().get());
            io.getIndexSubject().onNext((Object)new VideoIndex(Optional.empty(), vi.getElapsedTime(), Optional.of(timecode)));
        });
    }

    private Timecode durationToTimecode(Duration duration) {
        return new Timecode((double)duration.toMillis() / 10.0, 100.0);
    }

    private Duration timecodeToDuration(Timecode timecode) {
        Timecode newTimecode = new Timecode(timecode.toString(), 100.0);
        return Duration.ofMillis(Math.round(newTimecode.getSeconds() * 1000.0));
    }

    public void unsubscribe() {
    }
}

