/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.sharktopoda.decorators;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.subjects.PublishSubject;
import io.reactivex.rxjava3.subjects.Subject;
import java.io.File;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.util.Optional;
import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.commands.RemoteCommands;
import org.mbari.vcr4j.decorators.Decorator;
import org.mbari.vcr4j.sharktopoda.Constants;
import org.mbari.vcr4j.sharktopoda.SharktopodaError;
import org.mbari.vcr4j.sharktopoda.SharktopodaVideoIO;
import org.mbari.vcr4j.sharktopoda.commands.ConnectCmd;
import org.mbari.vcr4j.sharktopoda.commands.FramecaptureCmd;
import org.mbari.vcr4j.sharktopoda.model.request.Connect;
import org.mbari.vcr4j.sharktopoda.model.request.Framecapture;
import org.mbari.vcr4j.sharktopoda.model.response.FramecaptureResponse;

public class FramecaptureDecorator
implements Decorator {
    private final SharktopodaVideoIO io;
    private final int port;
    private DatagramSocket server;
    private final byte[] lock = new byte[]{1};
    private static final System.Logger log = System.getLogger(FramecaptureDecorator.class.getName());
    private final Subject<FramecaptureResponse> framecaptureSubject;
    private Disposable disposable;
    private volatile boolean ok = true;
    private final Observer<FramecaptureCmd> subscriber;
    private final Thread receiverThread;

    public FramecaptureDecorator(SharktopodaVideoIO io, int port) {
        this.io = io;
        this.port = port;
        PublishSubject s1 = PublishSubject.create();
        this.framecaptureSubject = s1.toSerialized();
        this.receiverThread = new Thread(() -> {
            byte[] buffer = new byte[4096];
            DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
            while (this.ok) {
                try {
                    this.getServer().receive(packet);
                    String msg = new String(packet.getData(), 0, packet.getLength());
                    log.log(System.Logger.Level.DEBUG, "Received <<< " + msg);
                    FramecaptureResponse r = (FramecaptureResponse)Constants.GSON.fromJson(msg, FramecaptureResponse.class);
                    this.framecaptureSubject.onNext((Object)r);
                }
                catch (Exception e) {
                    log.log(System.Logger.Level.INFO, "Error while reading UDP datagram", (Throwable)e);
                    io.getErrorSubject().onNext((Object)new SharktopodaError(true, true, false, Optional.empty()));
                    if (!this.server.isClosed()) {
                        this.server.close();
                    }
                    if (this.server == null) continue;
                    this.server = null;
                }
            }
            if (this.server != null) {
                this.server.close();
            }
            log.log(System.Logger.Level.INFO, "Shutting down UDP server that listens to Sharktopoda for framegrabs");
        });
        this.receiverThread.setDaemon(true);
        this.receiverThread.start();
        this.subscriber = new Observer<FramecaptureCmd>(){

            public void onComplete() {
                FramecaptureDecorator.this.ok = false;
            }

            public void onError(Throwable throwable) {
                FramecaptureDecorator.this.ok = false;
            }

            public void onNext(FramecaptureCmd cmd) {
                FramecaptureDecorator.this.doFrameCapture(cmd);
            }

            public void onSubscribe(Disposable disposable) {
                FramecaptureDecorator.this.disposable = disposable;
            }
        };
        io.getCommandSubject().ofType(FramecaptureCmd.class).subscribe(this.subscriber);
        io.getCommandSubject().ofType(ConnectCmd.class).forEach(this::doConnect);
        io.getCommandSubject().filter(cmd -> cmd == RemoteCommands.CLOSE).forEach(cmd -> {
            this.ok = false;
        });
        io.send(new ConnectCmd(port));
    }

    public Observable<FramecaptureResponse> getFramecaptureObservable() {
        return this.framecaptureSubject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatagramSocket getServer() throws SocketException {
        byte[] byArray = this.lock;
        synchronized (this.lock) {
            if (this.server == null || this.server.isClosed()) {
                this.server = new DatagramSocket(this.port);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.server;
        }
    }

    private void doFrameCapture(FramecaptureCmd cmd) {
        FramecaptureCmd.Params params = (FramecaptureCmd.Params)cmd.getValue();
        try {
            URL url = new File(params.getImageLocation()).toURI().toURL();
            Framecapture obj = new Framecapture(this.io.getUUID(), params.getImageReferenceUuid(), url.toExternalForm());
            DatagramPacket packet = this.io.asPacket(obj);
            this.io.sendCommand(packet, (VideoCommand)cmd);
        }
        catch (MalformedURLException e) {
            log.log(System.Logger.Level.INFO, "Unable to convert file path to URL", (Throwable)e);
        }
    }

    private void doConnect(ConnectCmd cmd) {
        ConnectCmd.Params params = cmd.getValue();
        Connect obj = new Connect(params.getPort(), params.getHost());
        DatagramPacket packet = this.io.asPacket(obj);
        this.io.sendCommand(packet, cmd);
    }

    public void unsubscribe() {
        this.server.close();
        this.ok = false;
        this.disposable.dispose();
    }
}

