/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class DeviceParameters
extends DeviceComponent {
    private JScrollPane scrollP;
    private int parameterOffset;
    private int numParameters;
    private JTextField[] valuesTF;
    private JLabel[] labels;

    @Override
    protected void initializeData(String data, boolean is_on) {
        this.mode = 3;
        this.valuesTF = new JTextField[this.numParameters];
        this.labels = new JLabel[this.numParameters];
        JPanel jp = new JPanel();
        jp.setLayout(new GridLayout(this.numParameters, 1));
        int currNid = this.baseNid + this.offsetNid + 2 + 3 * this.parameterOffset;
        for (int i = 0; i < this.numParameters; ++i) {
            JPanel jp1 = new JPanel();
            String parName = "";
            try {
                parName = this.subtree.getString(this.subtree.getDataExpr(currNid));
                parName = parName.substring(11);
            }
            catch (Exception exc) {
                System.out.println("Cannot read parameter name");
            }
            jp1.setBorder(new TitledBorder(parName));
            jp1.setLayout(new BorderLayout());
            this.valuesTF[i] = new JTextField();
            jp1.add((Component)this.valuesTF[i], "Center");
            jp.add(jp1);
            currNid += 3;
        }
        this.scrollP = new JScrollPane(jp);
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollP, "Center");
        this.displayData(data, is_on);
    }

    @Override
    protected void displayData(String data, boolean is_on) {
        int currNid = this.baseNid + this.offsetNid + 3 + 3 * this.parameterOffset;
        for (int parIdx = 0; parIdx < this.numParameters; ++parIdx) {
            try {
                this.valuesTF[parIdx].setText(this.subtree.getDataExpr(currNid));
            }
            catch (Exception exc) {
                System.out.println("Cannot read parameter value");
            }
            currNid += 3;
        }
    }

    @Override
    protected String getData() {
        return null;
    }

    @Override
    protected boolean getState() {
        return true;
    }

    @Override
    public void apply() throws Exception {
        int currNid = this.baseNid + this.offsetNid + 3 + 3 * this.parameterOffset;
        for (int parIdx = 0; parIdx < this.numParameters; ++parIdx) {
            try {
                this.subtree.putDataExpr(currNid, this.valuesTF[parIdx].getText());
            }
            catch (Exception exc) {
                System.out.println("Cannot write parameter " + this.labels[parIdx] + ": " + exc);
            }
            currNid += 3;
        }
    }

    public int getNumParameters() {
        return this.numParameters;
    }

    public void setNumParameters(int numParameters) {
        this.numParameters = numParameters;
    }

    public int getParameterOffset() {
        return this.parameterOffset;
    }

    public void setParameterOffset(int parameterOffset) {
        this.parameterOffset = parameterOffset;
    }
}

