/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import mds.wave.Waveform;

public class DeviceWaveDisplay
extends DeviceComponent {
    private static final long serialVersionUID = 1L;
    protected Waveform wave;
    protected String oldData;
    float[] x = null;
    float[] y = null;
    protected int prefHeight = 200;

    @Override
    protected void displayData(String data, boolean is_on) {
        try {
            String xData = "DIM_OF(" + data + ")";
            String yData = data;
            this.x = this.subtree.getFloatArray(xData);
            this.y = this.subtree.getFloatArray(yData);
            this.wave.Update(this.x, this.y);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected String getData() {
        return this.oldData;
    }

    public int getPrefHeight() {
        return this.prefHeight;
    }

    @Override
    protected boolean getState() {
        return true;
    }

    @Override
    protected void initializeData(String data, boolean is_on) {
        this.oldData = data;
        this.setLayout(new BorderLayout());
        this.wave = new Waveform();
        this.wave.setPreferredSize(new Dimension(300, 200));
        this.add((Component)this.wave, "Center");
        this.displayData(data, is_on);
    }

    @Override
    public boolean isDataChanged() {
        return false;
    }

    @Override
    void postApply() {
        this.displayData(this.oldData, true);
    }

    @Override
    public void print(Graphics g) {
        this.wave.paintComponent(g);
    }

    @Override
    public void reset() {
    }

    @Override
    public void setEnabled(boolean state) {
    }

    public void setPrefHeight(int prefHeight) {
        this.prefHeight = prefHeight;
    }
}

