/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DeviceChannel
extends DeviceComponent {
    static Hashtable componentHash = new Hashtable();
    public String labelString = null;
    public boolean borderVisible = false;
    public boolean inSameLine = false;
    protected JCheckBox checkB = null;
    protected Vector device_components = null;
    public int lines = 1;
    public int columns = 0;
    public String showVal;
    public boolean showState = true;
    private boolean initial_state;
    private boolean reportingChange = false;
    private JPopupMenu copyPastePopup;
    protected boolean initializing = true;
    protected JPanel componentsPanel;

    public void copy() {
        this.buildComponentList();
        for (int i = 0; i < this.device_components.size(); ++i) {
            DeviceComponent currComponent = (DeviceComponent)this.device_components.elementAt(i);
            int intOffset = currComponent.getOffsetNid() - this.getOffsetNid();
            componentHash.put(new Integer(intOffset), currComponent.getFullData());
        }
    }

    public void paste() {
        this.buildComponentList();
        for (int i = 0; i < this.device_components.size(); ++i) {
            DeviceComponent currComponent = (DeviceComponent)this.device_components.elementAt(i);
            int intOffset = currComponent.getOffsetNid() - this.getOffsetNid();
            Object currData = componentHash.get(new Integer(intOffset));
            if (currData == null) continue;
            currComponent.dataChanged(currComponent.getOffsetNid(), currData);
        }
    }

    public void propagate() {
        this.copy();
        Container parent = this.getParent();
        Component[] components = parent.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof DeviceChannel) || components[i] == this) continue;
            ((DeviceChannel)components[i]).paste();
        }
    }

    public Container getContainer() {
        return this.componentsPanel;
    }

    public void setShowVal(String showVal) {
        this.showVal = showVal;
    }

    public String getShowVal() {
        return this.showVal;
    }

    public void setShowState(boolean showState) {
        this.showState = showState;
    }

    public boolean getShowState() {
        return this.showState;
    }

    public void setInSameLine(boolean inSameLine) {
        this.inSameLine = inSameLine;
        if (this.checkB != null) {
            this.remove(this.checkB);
            if (inSameLine) {
                this.add((Component)this.checkB, "West");
            } else {
                this.add((Component)this.checkB, "North");
            }
        }
    }

    public boolean getInSameLine() {
        return this.inSameLine;
    }

    public void setLines(int lines) {
        this.initializing = true;
        this.lines = lines;
        if (lines != 0 && this.columns != 0) {
            this.componentsPanel.setLayout(new GridLayout(lines, this.columns));
        } else if (lines == 0 && this.columns == 0) {
            this.componentsPanel.setLayout(new FlowLayout());
        } else {
            this.componentsPanel.setLayout(new BorderLayout());
        }
        this.initializing = false;
    }

    public int getLines() {
        return this.lines;
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int columns) {
        this.initializing = true;
        this.columns = columns;
        if (this.lines != 0 && columns != 0) {
            this.componentsPanel.setLayout(new GridLayout(this.lines, columns));
        } else {
            this.componentsPanel.setLayout(new FlowLayout());
        }
        this.initializing = false;
    }

    public void setLabelString(String labelString) {
        this.labelString = labelString;
        if (this.checkB != null) {
            this.checkB.setText(labelString);
        }
        this.redisplay();
    }

    public String getLabelString() {
        return this.labelString;
    }

    public void setBorderVisible(boolean borderVisible) {
        this.borderVisible = borderVisible;
        if (borderVisible) {
            this.setBorder(new LineBorder(Color.black, 1));
        } else {
            this.setBorder(null);
        }
    }

    public boolean getBorderVisible() {
        return this.borderVisible;
    }

    public DeviceChannel() {
        this.mode = 1;
        this.setLayout(new BorderLayout());
        this.componentsPanel = new JPanel();
        this.checkB = new JCheckBox();
        this.add((Component)this.checkB, "North");
        this.checkB.setText(this.labelString);
        this.add((Component)this.componentsPanel, "Center");
        this.copyPastePopup = new JPopupMenu();
        JMenuItem copyI = new JMenuItem("Copy");
        copyI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeviceChannel.this.copy();
            }
        });
        this.copyPastePopup.add(copyI);
        JMenuItem pasteI = new JMenuItem("Paste");
        pasteI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeviceChannel.this.paste();
            }
        });
        this.copyPastePopup.add(pasteI);
        JMenuItem propagateI = new JMenuItem("Propagate");
        propagateI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeviceChannel.this.propagate();
            }
        });
        this.copyPastePopup.add(propagateI);
        this.copyPastePopup.pack();
        this.copyPastePopup.setInvoker(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if ((e.getModifiers() & 4) != 0) {
                    DeviceChannel.this.copyPastePopup.setInvoker(DeviceChannel.this);
                    DeviceChannel.this.copyPastePopup.show(DeviceChannel.this, e.getX(), e.getY());
                }
            }
        });
        this.initializing = false;
    }

    @Override
    protected void initializeData(String data, boolean is_on) {
        if (!this.showState) {
            this.remove(this.checkB);
            this.checkB = null;
        } else {
            this.checkB.setText(this.labelString);
            this.checkB.setSelected(is_on);
            this.checkB.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    DeviceChannel.this.reportingChange = true;
                    DeviceChannel.this.reportStateChanged(DeviceChannel.this.checkB.isSelected());
                    DeviceChannel.this.reportingChange = false;
                    DeviceChannel.this.propagateState(DeviceChannel.this.checkB.isSelected());
                }
            });
        }
        this.propagateState(is_on);
    }

    @Override
    protected void stateChanged(int offsetNid, boolean state) {
        if (this.offsetNid != offsetNid || this.reportingChange) {
            return;
        }
        if (this.checkB != null) {
            this.checkB.setSelected(state);
        }
    }

    @Override
    protected void displayData(String data, boolean is_on) {
        this.initial_state = is_on;
        if (this.checkB != null) {
            this.checkB.setSelected(is_on);
        }
        this.propagateState(is_on);
    }

    @Override
    protected String getData() {
        return null;
    }

    @Override
    protected boolean getState() {
        if (!this.showState || this.checkB == null) {
            return this.initial_state;
        }
        return this.checkB.isSelected();
    }

    private void buildComponentList() {
        if (this.device_components == null) {
            this.device_components = new Vector();
            Stack<Component> search_stack = new Stack<Component>();
            search_stack.push(this);
            do {
                Component[] curr_components;
                if ((curr_components = ((Container)search_stack.pop()).getComponents()) == null) continue;
                for (int i = 0; i < curr_components.length; ++i) {
                    if (curr_components[i] instanceof DeviceComponent) {
                        this.device_components.addElement(curr_components[i]);
                        continue;
                    }
                    if (!(curr_components[i] instanceof Container)) continue;
                    search_stack.push(curr_components[i]);
                }
            } while (!search_stack.empty());
        }
    }

    private void propagateState(boolean state) {
        this.buildComponentList();
        int size = this.device_components.size();
        for (int i = 0; i < size; ++i) {
            ((DeviceComponent)this.device_components.elementAt(i)).setEnabled(state);
        }
    }

    @Override
    public void setEnabled(boolean state) {
        if (this.checkB != null) {
            this.checkB.setEnabled(state);
        }
        this.buildComponentList();
        if (this.device_components != null) {
            int size = this.device_components.size();
            for (int i = 0; i < size; ++i) {
                ((DeviceComponent)this.device_components.elementAt(i)).setEnabled(state);
            }
        }
    }

    @Override
    public void setLayout(LayoutManager layout) {
        if (!this.initializing) {
            return;
        }
        super.setLayout(layout);
    }

    @Override
    public Component add(Component c) {
        if (!this.initializing) {
            return this.componentsPanel.add(c);
        }
        return super.add(c);
    }

    @Override
    public Component add(String name, Component c) {
        if (!this.initializing) {
            return this.componentsPanel.add(c);
        }
        return super.add(c);
    }

    @Override
    public Component add(Component c, int intex) {
        if (!this.initializing) {
            return this.componentsPanel.add(c);
        }
        return super.add(c);
    }

    @Override
    public void fireUpdate(String updateId, String newExpr) {
        if (updateId == null || !this.updateIdentifier.equals(updateId)) {
            return;
        }
        String newVal = newExpr.toString();
        newVal = newVal.substring(1, newVal.length() - 1);
        if (this.showVal != null && this.showVal.equals(newVal)) {
            this.setEnabledAll(true);
            LayoutManager layout = this.getParent().getLayout();
            if (layout != null && layout instanceof CardLayout) {
                ((CardLayout)layout).show(this.getParent(), this.showVal);
            }
        } else {
            this.setEnabledAll(false);
        }
    }

    @Override
    protected boolean supportsState() {
        return this.showState;
    }

    protected void setEnabledAll(boolean enabled) {
        this.buildComponentList();
        if (this.device_components != null) {
            int size = this.device_components.size();
            for (int i = 0; i < size; ++i) {
                if (enabled) {
                    ((DeviceComponent)this.device_components.elementAt(i)).setEnable();
                    continue;
                }
                ((DeviceComponent)this.device_components.elementAt(i)).setDisable();
            }
        }
    }

    @Override
    public void postConfigure() {
        this.propagateState(this.curr_on);
    }
}

