/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class DeviceChoice
extends DeviceComponent {
    private static final long serialVersionUID = 1L;
    protected boolean showState = false;
    protected String labelString = null;
    private boolean initial_state;
    protected String[] choiceItems;
    protected int[] choiceIntValues = null;
    protected float[] choiceFloatValues = null;
    protected double[] choiceDoubleValues = null;
    protected boolean convert = false;
    private boolean reportingChange = false;
    protected JCheckBox checkB = new JCheckBox();
    protected JComboBox comboB;
    protected JLabel label;
    protected boolean initializing = true;

    public void setConvert(boolean convert) {
        this.convert = convert;
    }

    public boolean getConvert() {
        return this.convert;
    }

    public void setChoiceItems(String[] choiceItems) {
        this.choiceItems = choiceItems;
        if (this.comboB != null) {
            this.comboB.removeAllItems();
            if (choiceItems != null) {
                for (String item : choiceItems) {
                    this.comboB.addItem(item);
                }
            }
        }
    }

    public String[] getChoiceItems() {
        return this.choiceItems;
    }

    public void setChoiceIntValues(int[] choiceIntValues) {
        this.choiceIntValues = choiceIntValues;
    }

    public int[] getChoiceIntValues() {
        return this.choiceIntValues;
    }

    public void setChoiceFloatValues(float[] choiceFloatValues) {
        this.choiceFloatValues = choiceFloatValues;
    }

    public float[] getChoiceFloatValues() {
        return this.choiceFloatValues;
    }

    public void setChoiceDoubleValues(double[] choiceDoubleValues) {
        this.choiceDoubleValues = choiceDoubleValues;
    }

    public double[] getChoiceDoubleValues() {
        return this.choiceDoubleValues;
    }

    public void setLabelString(String labelString) {
        this.labelString = labelString;
        this.label.setText(labelString);
        this.redisplay();
    }

    public String getLabelString() {
        return this.labelString;
    }

    public void setShowState(boolean showState) {
        this.showState = showState;
        if (showState) {
            this.checkB.setVisible(true);
        }
        this.redisplay();
    }

    public boolean getShowState() {
        return this.showState;
    }

    public DeviceChoice() {
        this.add(this.checkB);
        this.checkB.setVisible(false);
        this.label = new JLabel("Choice: ");
        this.add(this.label);
        this.comboB = new JComboBox<String>(new String[]{"Item"});
        this.add(this.comboB);
        this.initializing = false;
    }

    @Override
    protected void initializeData(String data, boolean is_on) {
        this.initial_state = is_on;
        this.initializing = true;
        this.displayData(data, is_on);
        this.comboB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DeviceChoice.this.initializing) {
                    return;
                }
                DeviceChoice.this.reportingChange = true;
                DeviceChoice.this.reportDataChanged(new Integer(DeviceChoice.this.comboB.getSelectedIndex()));
                DeviceChoice.this.reportingChange = false;
                if (DeviceChoice.this.updateIdentifier == null || DeviceChoice.this.updateIdentifier.equals("")) {
                    return;
                }
                String currItem = (String)DeviceChoice.this.comboB.getSelectedItem();
                DeviceChoice.this.master.fireUpdate(DeviceChoice.this.updateIdentifier, currItem);
            }
        });
        this.initializing = false;
    }

    @Override
    protected void dataChanged(int offsetNid, Object data) {
        if (this.reportingChange || this.offsetNid != offsetNid) {
            return;
        }
        try {
            if (data instanceof Integer) {
                this.comboB.setSelectedIndex((Integer)data);
            }
        }
        catch (Exception exc) {
            System.err.println("DeviceChoice.dataChanged: " + exc);
        }
    }

    @Override
    public void postConfigure() {
        String currItem = (String)this.comboB.getSelectedItem();
        if (this.master != null && this.updateIdentifier != null) {
            this.master.fireUpdate(this.updateIdentifier, currItem);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void displayData(String data, boolean is_on) {
        this.initial_state = is_on;
        if (this.showState) {
            this.checkB.setSelected(is_on);
        }
        if (this.convert) {
            try {
                data_value = this.subtree.getInt(data);
            }
            catch (Exception e) {
                data_value = 0;
            }
            if (this.choiceIntValues != null) {
                for (i = 0; i < this.choiceIntValues.length; ++i) {
                    if (data_value != this.choiceIntValues[i]) continue;
                    this.comboB.setSelectedIndex(i);
                    break;
                }
            } else {
                this.comboB.setSelectedIndex(data_value);
            }
        } else {
            try {
                data_value = this.subtree.getString(data);
                for (i = 0; i < this.choiceItems.length; ++i) {
                    if (!this.choiceItems[i].equals(data_value)) continue;
                    this.comboB.setSelectedIndex(i);
                }
            }
            catch (Exception e0) {
                try {
                    if (this.choiceIntValues != null) {
                        data_value = this.subtree.getInt(data);
                        for (i = 0; i < this.choiceIntValues.length; ++i) {
                            if (data_value != this.choiceIntValues[i]) continue;
                            this.comboB.setSelectedIndex(i);
                        }
                    }
                    if (this.choiceFloatValues != null) {
                        data_value = this.subtree.getFloat(data);
                        for (i = 0; i < this.choiceFloatValues.length; ++i) {
                            if (data_value == this.choiceFloatValues[i]) continue;
                            this.comboB.setSelectedIndex(i);
                        }
                    }
                    if (this.choiceDoubleValues == null) ** GOTO lbl50
                    data_value = this.subtree.getDouble(data);
                    for (i = 0; i < this.choiceDoubleValues.length; ++i) {
                        if (data_value == this.choiceDoubleValues[i]) continue;
                        this.comboB.setSelectedIndex(i);
                    }
                }
                catch (Exception var4_12) {
                    // empty catch block
                }
            }
        }
        this.setEnabled(is_on);
    }

    @Override
    protected String getData() {
        int curr_idx = this.comboB.getSelectedIndex();
        if (this.convert) {
            if (this.choiceIntValues != null) {
                return "" + this.choiceIntValues[curr_idx];
            }
            return "" + curr_idx;
        }
        if (this.choiceIntValues != null) {
            return "" + this.choiceIntValues[curr_idx];
        }
        if (this.choiceFloatValues != null) {
            return "" + this.choiceFloatValues[curr_idx];
        }
        if (this.choiceDoubleValues != null) {
            return "" + this.choiceDoubleValues[curr_idx];
        }
        return this.choiceItems[curr_idx];
    }

    @Override
    protected boolean getState() {
        if (!this.showState) {
            return this.initial_state;
        }
        return this.checkB.isSelected();
    }

    @Override
    public void setEnabled(boolean state) {
        if (this.comboB != null) {
            this.comboB.setEnabled(state);
        }
        if (this.label != null) {
            this.label.setEnabled(state);
        }
    }

    @Override
    public Component add(Component c) {
        if (!this.initializing) {
            JOptionPane.showMessageDialog(null, "You cannot add a component to a Device Choice. Please remove the component.", "Error adding Device field", 2);
            return null;
        }
        return super.add(c);
    }

    @Override
    public Component add(String name, Component c) {
        if (!this.initializing) {
            JOptionPane.showMessageDialog(null, "You cannot add a component to a Device Choice. Please remove the component.", "Error adding Device field", 2);
            return null;
        }
        return super.add(c);
    }

    @Override
    public Component add(Component c, int intex) {
        if (!this.initializing) {
            JOptionPane.showMessageDialog(null, "You cannot add a component to a Device Choice. Please remove the component.", "Error adding Device field", 2);
            return null;
        }
        return super.add(c);
    }

    @Override
    public void setHighlight(boolean highlighted) {
        if (highlighted) {
            if (this.label != null) {
                this.label.setForeground(Color.red);
            }
        } else if (this.label != null) {
            this.label.setForeground(Color.black);
        }
        super.setHighlight(highlighted);
    }
}

