/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;

public class DeviceDispatch
extends DeviceComponent {
    private static final long serialVersionUID = 1L;
    private DeviceDispatchField[] dispatch_fields;
    private DeviceDispatchField active_field;
    private String[] actions;
    private JDialog dialog = null;
    private final JComboBox menu = new JComboBox();
    protected boolean initializing = false;

    public DeviceDispatch() {
        this.menu.setEditor(new DispatchComboEditor());
        this.menu.setEditable(true);
        this.menu.setBorder(new LineBorder(Color.black, 1));
        this.add(this.menu);
    }

    @Override
    protected void initializeData(String data, boolean is_on) {
        int num_components;
        this.initializing = true;
        if (this.subtree == null) {
            return;
        }
        try {
            num_components = this.subtree.getNumConglomerateNids(this.nidData);
        }
        catch (Exception exc) {
            num_components = 0;
        }
        int endNid = this.baseNidData + num_components;
        int[] action_nids = new int[num_components];
        int num_actions = 0;
        for (int nid = this.baseNidData; nid < endNid; ++nid) {
            try {
                if (!this.subtree.getUsage(nid).equals("ACTION")) continue;
                action_nids[num_actions++] = nid;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.actions = new String[num_actions];
        this.dispatch_fields = new DeviceDispatchField[num_actions];
        for (int i = 0; i < num_actions; ++i) {
            int nid = action_nids[i];
            try {
                this.actions[i] = this.subtree.getDataExpr(nid);
            }
            catch (Exception e) {
                System.out.println("Cannot read device actions: " + e);
                return;
            }
            try {
                String name = this.subtree.getNodeName(nid);
                this.menu.addItem(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.dispatch_fields[i] = new DeviceDispatchField();
            this.dispatch_fields[i].setSubtree(this.subtree);
            this.dispatch_fields[i].setOffsetNid(nid - this.baseNidData);
            this.dispatch_fields[i].configure(this.nidData);
        }
        this.menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int idx = DeviceDispatch.this.menu.getSelectedIndex();
                if (idx < 0 || idx >= DeviceDispatch.this.dispatch_fields.length) {
                    return;
                }
                DeviceDispatch.this.activateForm(DeviceDispatch.this.dispatch_fields[DeviceDispatch.this.menu.getSelectedIndex()], (String)DeviceDispatch.this.menu.getSelectedItem());
            }
        });
        this.initializing = false;
    }

    protected void activateForm(DeviceDispatchField field, String name) {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.master);
            this.dialog.getContentPane().setLayout(new BorderLayout());
            this.dialog.getContentPane().add((Component)field, "Center");
            JPanel jp = new JPanel();
            JButton button = new JButton("Done");
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DeviceDispatch.this.dialog.dispose();
                }
            });
            jp.add(button);
            this.dialog.getContentPane().add((Component)jp, "South");
            this.active_field = field;
        } else {
            this.dialog.getContentPane().remove(this.active_field);
            this.dialog.getContentPane().add((Component)field, "Center");
            this.active_field = field;
        }
        this.dialog.setTitle("Dispatch info for " + name);
        this.dialog.pack();
        this.dialog.repaint();
        this.dialog.setLocation(this.master.getLocationOnScreen());
        this.dialog.setVisible(true);
    }

    @Override
    protected void displayData(String data, boolean is_on) {
    }

    @Override
    protected String getData() {
        return null;
    }

    @Override
    protected boolean getState() {
        return true;
    }

    @Override
    public void apply() throws Exception {
        if (this.dispatch_fields == null) {
            return;
        }
        for (int i = 0; i < this.dispatch_fields.length; ++i) {
            this.dispatch_fields[i].apply();
        }
    }

    @Override
    public void reset() {
        if (this.dispatch_fields == null) {
            return;
        }
        for (int i = 0; i < this.dispatch_fields.length; ++i) {
            this.dispatch_fields[i].reset();
        }
    }

    @Override
    public void apply(int currBaseNid) {
    }

    class DispatchComboEditor
    implements ComboBoxEditor {
        JLabel label = new JLabel("  Dispatch");
        int idx;
        String name;

        DispatchComboEditor() {
        }

        @Override
        public void addActionListener(ActionListener l) {
        }

        @Override
        public void removeActionListener(ActionListener l) {
        }

        @Override
        public Component getEditorComponent() {
            return this.label;
        }

        @Override
        public Object getItem() {
            return this.label;
        }

        @Override
        public void selectAll() {
        }

        @Override
        public void setItem(Object obj) {
        }
    }
}

