/*
 * Decompiled with CFR 0.152.
 */
import java.awt.GridLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class DeviceDispatchField
extends DeviceComponent {
    private static final long serialVersionUID = 1L;
    protected DeviceLabeledExprEditor ident;
    protected DeviceLabeledExprEditor phase;
    protected DeviceLabeledExprEditor when;
    protected DeviceLabeledExprEditor completion;
    protected String action;
    protected String dispatch;
    protected JCheckBox state;

    @Override
    protected void initializeData(String data, boolean is_on) {
        String completionStr;
        String phaseStr;
        String server;
        this.action = data;
        this.dispatch = "DISPATCH_OF(" + data + ")";
        this.setLayout(new GridLayout(4, 1));
        try {
            server = this.subtree.getString("IDENT_OF(" + this.dispatch + ")");
            if (server != null && server.trim().length() > 0) {
                server = "\"" + server + "\"";
            }
        }
        catch (Exception exc) {
            server = "";
        }
        this.ident = new DeviceLabeledExprEditor("Ident:         ", new DeviceExprEditor(server, true));
        this.add(this.ident);
        try {
            phaseStr = this.subtree.getString("PHASE_OF(" + this.dispatch + ")");
            if (phaseStr != null && phaseStr.trim().length() > 0) {
                phaseStr = "\"" + phaseStr + "\"";
            }
        }
        catch (Exception exc) {
            phaseStr = "";
        }
        this.phase = new DeviceLabeledExprEditor("Phase:        ", new DeviceExprEditor(phaseStr, true));
        this.add(this.phase);
        try {
            completionStr = this.subtree.getString("COMPLETION_OF(" + this.dispatch + ")");
            if (completionStr != null && completionStr.trim().length() > 0) {
                completionStr = "\"" + completionStr + "\"";
            }
        }
        catch (Exception exc) {
            completionStr = "";
        }
        this.completion = new DeviceLabeledExprEditor("Completion:", new DeviceExprEditor(completionStr, true));
        this.add(this.completion);
        JPanel jp = new JPanel();
        try {
            int sequence = this.subtree.getInt("WHEN_OF(" + this.dispatch + ")");
            this.when = new DeviceLabeledExprEditor("Sequence:  ", new DeviceExprEditor("" + sequence, false, 1, 6));
            jp.add(this.when);
        }
        catch (Exception exc) {
            String whenStr;
            try {
                whenStr = this.subtree.execute("WHEN_OF(" + this.dispatch + ")");
            }
            catch (Exception exc1) {
                whenStr = "";
            }
            this.when = new DeviceLabeledExprEditor("When:  ", new DeviceExprEditor(whenStr, false, 1, 6));
            jp.add(this.when);
        }
        this.state = new JCheckBox("Is On", is_on);
        jp.add(this.state);
        this.add(jp);
    }

    @Override
    protected void displayData(String data, boolean is_on) {
        String completionStr;
        String phaseStr;
        String server;
        try {
            this.dispatch = this.subtree.execute("DISPATCH_OF(" + data + ")");
        }
        catch (Exception exc) {
            this.ident.setData("");
            this.phase.setData("");
            this.completion.setData("");
            this.when.setData("");
            return;
        }
        try {
            server = this.subtree.getString("IDENT_OF(" + this.dispatch + ")");
        }
        catch (Exception exc) {
            server = "";
        }
        this.ident.setData("\"" + server + "\"");
        try {
            phaseStr = this.subtree.getString("PHASE_OF(" + this.dispatch + ")");
        }
        catch (Exception exc) {
            phaseStr = "";
        }
        this.phase.setData("\"" + phaseStr + "\"");
        try {
            completionStr = this.subtree.getString("COMPLETION_OF(" + this.dispatch + ")");
        }
        catch (Exception exc) {
            completionStr = "";
        }
        this.completion.setData("\"" + completionStr + "\"");
        try {
            int sequence = this.subtree.getInt("WHEN_OF(" + this.dispatch + ")");
            this.when.setData("" + sequence);
        }
        catch (Exception exc) {
            String whenStr;
            try {
                whenStr = this.subtree.execute("WHEN_OF(" + this.dispatch + ")");
            }
            catch (Exception exc1) {
                whenStr = "";
            }
            this.when.setData(whenStr);
        }
        this.state.setSelected(is_on);
    }

    @Override
    protected String getData() {
        int type;
        try {
            this.subtree.getInt(this.when.getData());
            type = 2;
        }
        catch (Exception exc) {
            type = 3;
        }
        try {
            String retAction = "BUILD_ACTION(BUILD_DISPATCH(" + type + "," + this.ident.getData() + "," + this.phase.getData() + "," + this.when.getData() + "," + this.completion.getData() + ")," + this.subtree.execute("TASK_OF(" + this.action + ")") + ")";
            return retAction;
        }
        catch (Exception exc) {
            return null;
        }
    }

    @Override
    protected boolean getState() {
        return this.state.isSelected();
    }

    @Override
    public void setEnabled(boolean state) {
    }

    @Override
    protected boolean isDataChanged() {
        try {
            return this.subtree.getShot() == -1;
        }
        catch (Exception exc) {
            return false;
        }
    }
}

